package ch.sahits.game.openpatrician.engine;

import ch.sahits.game.openpatrician.model.initialisation.MapInitializedBean;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * Spring configuration for the engine module.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 02, 2014
 */
@Configuration
@ComponentScan
@ClassCategory(EClassCategory.STARTUP)
public class EngineConfiguration {
    /** Interval for the clock tick timer */
    public final static int CLOCK_TICK_INTERVALL_MS = 100;
    @Bean
    public static PropertyPlaceholderConfigurer applicationServerProperties() {
        PropertyPlaceholderConfigurer bean = new PropertyPlaceholderConfigurer();
        bean.setIgnoreUnresolvablePlaceholders(true);
        bean.setLocations(new Resource[]{new ClassPathResource("model-settings.properties")});
        return bean;
    }

    @Bean
    @Scope("prototype")
    public StartNewGameBean startNewGameBean() {
        return new StartNewGameBean();
    }
    @Bean
    @Scope("prototype")
    public MapInitializedBean mapInitializedBean() {
        return new MapInitializedBean();
    }
    @Bean
    public ClockTickTimer clockTickTimer() {
        return new ClockTickTimer(CLOCK_TICK_INTERVALL_MS, ClockTickTimer.DURATION_INFINITY);
    }
    @Bean
    public ExecutorService paralleizationExecutor() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newFixedThreadPool(threads);
    }
    @Bean
    public ScheduledExecutorService schedulableServerThreadPool() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(threads/2 + 1);
    }

    @Bean
    public ScheduledExecutorService serverTimer() {
        int threads = Runtime.getRuntime().availableProcessors();
        return Executors.newScheduledThreadPool(threads/2 + 1);
    }
}
