package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;

/**
 * Timed task to for weekly loaner checks.
 * Created by andi on 20.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WeeklyLoanerCheckTask extends TimedTask {
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private StateFactory stateFactory;
    @Autowired
    private LoanerList loaners;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @XStreamOmitField
    private ServerSideTaskFactory taskFactory;
    @PostConstruct
    private void initialize() {
        setExecutionTime(getScheduledDateWeeklyUpdate());
    }

    private LocalDateTime getScheduledDateWeeklyUpdate() {
        return date.getCurrentDate().plusWeeks(1);
    }

    @Override
    public void run() {
        handleWeeklyUpdates();
    }

    private void handleWeeklyUpdates() {
        try {
            for (ILoaner loaner : loaners) {
                stateFactory.updateLoanerRequestsAndLoans(loaner);
            }
        } finally {
            scheduleNextWeekUpdate();
        }
    }

    private void scheduleNextWeekUpdate() {
        taskList.add(taskFactory.getWeeklyLoanerCheck());
    }
}
