package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Election;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.OpenPatricianRandom;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.utilities.collections.SortedMapRandomizedSameElements;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on May 17, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ElectionTask extends TimedTask {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(ElectionTask.class);
    @Autowired
    @XStreamOmitField
    private OpenPatricianRandom oprnd;

    private final SortedMapRandomizedSameElements candidateMap;
    private final Election result;

    public ElectionTask(SortedMapRandomizedSameElements candidateMap, Election result, LocalDateTime electionTime) {
        this.candidateMap = candidateMap;
        this.result = result;
        setExecutionTime(electionTime);
    }

    @Override
    public void run() {
        int index = oprnd.nextSlidingRandomDecreasing(candidateMap.size() - 1, 0.5); // todo: andi 5/17/15: this should probably be dependent on the popularity of the top candidate
        List<ICitizen> citizens = candidateMap.getAtIndex(index);
        result.vote(citizens.get(0));
        LOGGER.debug("Cast vote");
    }
}
