package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.model.city.cityhall.impl.Ballot;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

import java.time.LocalDateTime;

/**
 * Voting task that is timed.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 02, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class VoteTask extends TimedTask {
    private final Ballot result;
    private final boolean voteYes;
    public VoteTask(Ballot result, LocalDateTime electionTime, boolean yes) {
        this.result = result;
        voteYes = yes;
        setExecutionTime(electionTime);
    }

    @Override
    public void run() {
        result.vote(voteYes);
    }
}
