package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.TradeManagerService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategy;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
public abstract class BaseHireDismissTradeManagerStrategy implements IAIHireTradeManagerStrategy {

    @Autowired
    private TradeManagerService tradeManagerService;
    
    public void hireOrDismiss(ICity city, IAIPlayer player) {
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        optOffice.ifPresent(iTradingOffice -> {
            ITradingOffice office = iTradingOffice;
            if (!office.getSteward().isPresent()) {
                tradeManagerService.hireSteward(office);
            }
        });
    }
}
