package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.ITradeStategyHint;
import ch.sahits.game.openpatrician.model.player.ITradeStrategyHintContext;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

/**
 * Strategy hint for a central supply city.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 21, 2017
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class CentralStorageStrategyHint implements ITradeStategyHint {
    private CentralStorageHintContext context;

    @Override
    public ITradeStrategyHintContext getContext() {
        return context;
    }

    @Override
    public void setContext(ITradeStrategyHintContext context) {
         this.context = (CentralStorageHintContext) context;
    }
}
