package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAIHireSailorStrategy;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorsStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 04, 2017
 */
public enum EHireSailorStrategyType implements IAIHireSailorsStrategyType {
    DANGER_BASED_HIREING(DefaultHireSailorsStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAIHireSailorStrategy> strategyClass;

    EHireSailorStrategyType(Class<? extends IAIHireSailorStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAIHireSailorStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
