package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

import java.util.Optional;

/**
 * Strategy based hiring on storage capacity and usage.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class HireDismissTradeManagerMinStorageCapacityStrategy extends BaseHireDismissTradeManagerStrategy {

    /**
     * Hire if there is storage capacity larger than 1000 barrels and 80% are occupied.
     */
    @Override
    public boolean hireOrFireTradeManager(ICity city, IAIPlayer player) {
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent()) {
            ITradingOffice office = optOffice.get();
            if (office.getSteward().isPresent()) {
                return false; // never dismiss
            } else {
                int capacity = office.capacityProperty().get();
                return capacity >= 1000 && capacity - office.storedAmountBinding().get() <= (int)(0.2 * capacity);
            }
        }
        return false;
    }
}
