package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.Optional;

/**
 * Always join the guild if the player has a certain amount of cash dependent on the entry fee.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 15, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class NearTradingOfficeJoinGuildMinCashStrategy extends BaseJoinGuildStrategy {
    private final static int MAX_DISTANCE_IN_KM = 100;

    private double maxDistanceInPixels;

    @Autowired
    private IMap map;
    @PostConstruct
    void init() {
        maxDistanceInPixels = MAX_DISTANCE_IN_KM * map.getNumberOfPixelPerKilometer();
    }


    @Override
    protected boolean additionalJoinRequirementsMet(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel) {
        for (ICity otherCity : map.getCities()) {
            Optional<ITradingOffice> optOffice = player.findTradingOffice(otherCity);
            if (optOffice.isPresent()) {
                double distance = otherCity.getCoordinates().distance(city.getCoordinates());
                if (distance < maxDistanceInPixels) {
                    return true;
                }
            }
        }
        return false;
    }
}
