package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import java.util.ArrayList;

/**
 * Trade step aggregating several wares to sell.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class AggregatesCheckedSellTradeStep implements ITradeStep {
    @Setter
    private INavigableVessel vessel;
    @Setter
    private ICity city;
    @Setter
    private boolean executeNext = true;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @ListType(BuyTradeStep.class)
    private ArrayList<CheckedSellTradeStep> tradeSteps = new ArrayList<>();

    public void addSellStep(IWare ware, int amount) {
        CheckedSellTradeStep buyStep = context.getBean(CheckedSellTradeStep.class);
        buyStep.setExecuteNext(executeNext);
        buyStep.setCity(city);
        buyStep.setVessel(vessel);
        buyStep.setWare(ware);
        buyStep.setMaxAmount(amount);
        tradeSteps.add(buyStep);
    }

    @Override
    public boolean execute() {
        Preconditions.checkArgument(vessel.getLocation().equals(city.getCoordinates()), "The vessel is not in city "+city.getName()+" but at "+vessel.getLocation());
        for (CheckedSellTradeStep sellTradeStep : tradeSteps) {
            if (vessel.getWare(sellTradeStep.getWare()).getAmount() > 0) {
                sellTradeStep.execute();
            }
        }
        return executeNext;
    }
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        tradeSteps.stream().forEach(step -> sb.append(step.getWare().name()).append(" "));
        return "AggregatesCheckedSellTradeStep in "+city.getName()+" buying: "+ sb.toString();
    }

}
