/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.event.data.RepairFinishedEvent;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class RepairPirateShipTask
extends TimedTask {
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final INavigableVessel vessel;
    private final IShipyard shipyard;

    public RepairPirateShipTask(LocalDateTime executionTime, INavigableVessel vessel, ISeaPirate pirate, IShipyard shipyard) {
        Preconditions.checkArgument((vessel instanceof IShip || vessel instanceof IShipGroup ? 1 : 0) != 0);
        this.setExecutionTime(executionTime);
        this.vessel = vessel;
        this.shipyard = shipyard;
    }

    public void run() {
        if (this.vessel instanceof IShip) {
            IShip ship = (IShip)this.vessel;
            this.executeRepair(ship);
        } else {
            for (IShip ship : ((IShipGroup)this.vessel).getShips()) {
                this.executeRepair(ship);
            }
        }
        this.clientServerEventBus.post((Object)new RepairFinishedEvent(this.vessel));
    }

    private void executeRepair(IShip ship) {
        ship.repair();
        this.shipyard.removeCompletedRepair(ship);
        ship.setAvailable(true);
    }
}

