/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.openpatrician.engine.AbstractEngine;
import ch.sahits.game.openpatrician.engine.event.task.ServerSideTaskFactory;
import ch.sahits.game.openpatrician.engine.event.task.WeaponConstructionTask;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.weapon.ArmoryRegistry;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BlacksmithEngine
extends AbstractEngine {
    private static final EWare[] wares = new EWare[]{EWare.WOOD, EWare.IRON, EWare.LEATHER, EWare.HEMP};
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private ArmoryRegistry armories;
    @Autowired
    private Date date;
    @Autowired
    private ServerSideTaskFactory taskFactory;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Value(value="${cutlass.min.experience}")
    private double cutlassMinExperiance = 0.0;
    @Value(value="${sword.min.experience}")
    private double swordMinExperiance = 0.0;
    @Value(value="${bow.min.experience}")
    private double bowMinExperiance = 0.0;
    @Value(value="${crossbow.min.experience}")
    private double crossbowMinExperiance = 0.1;
    @Value(value="${musket.min.experience}")
    private double musketMinExperiance = 0.5;
    @Value(value="${trebuchet.small.min.experience}")
    private double trebuchetSmallMinExperiance = 0.0;
    @Value(value="${trebuchet.big.min.experience}")
    private double trebuchetBigMinExperiance = 0.2;
    @Value(value="${ballista.small.min.experience}")
    private double ballistaSmallMinExperiance = 0.0;
    @Value(value="${ballista.big.min.experience}")
    private double ballistaBigMinExperiance = 0.3;
    @Value(value="${bombard.min.experience}")
    private double bombardMinExperiance = 0.7;
    @Value(value="${canon.min.experience}")
    private double canonMinExperiance = 1.0;
    @Value(value="${cutlass.duration}")
    private int cutlassDuration = 1;
    @Value(value="${sword.duration}")
    private int swordDuration = 3;
    @Value(value="${bow.duration}")
    private int bowDuration = 2;
    @Value(value="${crossbow.duration}")
    private int crossbowDuration = 3;
    @Value(value="${musket.duration}")
    private int musketDuration = 3;
    @Value(value="${trebuchet.small.duration}")
    private int trebuchetSmallDuration = 20;
    @Value(value="${trebuchet.big.duration}")
    private int trebuchetBigDuration = 35;
    @Value(value="${ballista.small.duration}")
    private int ballistaSmallDuration = 20;
    @Value(value="${ballista.big.duration}")
    private int ballistaBigDuration = 35;
    @Value(value="${bombard.duration}")
    private int bombardDuration = 37;
    @Value(value="${canon.duration}")
    private int canonDuration = 28;

    @PostConstruct
    private void init() {
        this.timerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.timerEventBus.unregister((Object)this);
    }

    @Override
    public List<AbstractEngine> getChildren() {
        return Lists.newArrayList();
    }

    @Subscribe
    public void handleDailyUpdate(ClockTickDayChange event) {
        for (Map.Entry entry : this.armories) {
            Optional<EWeapon> weaponToProduce;
            IArmory armory = (IArmory)entry.getValue();
            ICity city = (ICity)entry.getKey();
            if (!this.date.getCurrentDate().isAfter(armory.occupiedUntil()) || !(weaponToProduce = this.findWeaponToProduce(armory, city)).isPresent()) continue;
            EWeapon weapon = weaponToProduce.get();
            for (EWare ware : wares) {
                int amount = this.getConstructionAmount(weapon, ware);
                city.move((IWare)ware, -amount, null);
            }
            LocalDateTime finished = this.date.getCurrentDate().plusDays(this.getBuildDuration(weapon));
            armory.occupy(finished);
            WeaponConstructionTask task = this.taskFactory.getWeaponConstructionFinishedTask(armory, weapon);
            task.setExecutionTime(finished);
            this.taskList.add((TimedTask)task);
        }
    }

    @VisibleForTesting
    Optional<EWeapon> findWeaponToProduce(IArmory armory, ICity city) {
        ArrayList producableWeapons = Lists.newArrayList();
        producableWeapons.addAll(Arrays.asList(EWeapon.values()));
        this.filterCapability(producableWeapons, armory.getExperience());
        this.filterWareAvailability(producableWeapons, city);
        this.filterAndSortPriority(producableWeapons, armory);
        this.sortWeaponAvailability(producableWeapons, armory);
        if (producableWeapons.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EWeapon)producableWeapons.get(0));
    }

    private void sortWeaponAvailability(List<EWeapon> producableWeapons, IArmory armory) {
        WeaponAvailabilityComparator comparator = new WeaponAvailabilityComparator(armory);
        producableWeapons.sort(comparator);
    }

    private void filterAndSortPriority(List<EWeapon> producableWeapons, IArmory armory) {
        ArrayList prioWeapons = Lists.newArrayList();
        for (EWeapon weapon : producableWeapons) {
            switch (weapon) {
                case SWORD: {
                    if (!armory.isSwordPriority()) break;
                    prioWeapons.add(weapon);
                    break;
                }
                case BOW: {
                    if (!armory.isBowPriority()) break;
                    prioWeapons.add(weapon);
                    break;
                }
                case CROSSBOW: {
                    if (!armory.isCrossbowPriority()) break;
                    prioWeapons.add(weapon);
                    break;
                }
                case MUSKET: {
                    if (!armory.isMusketPriority()) break;
                    prioWeapons.add(weapon);
                }
            }
        }
        if (!prioWeapons.isEmpty()) {
            producableWeapons.clear();
            producableWeapons.addAll(prioWeapons);
        }
    }

    private void filterWareAvailability(List<EWeapon> producableWeapons, ICity city) {
        Iterator<EWeapon> iterator = producableWeapons.iterator();
        while (iterator.hasNext()) {
            EWeapon weapon = iterator.next();
            boolean remove = false;
            for (EWare ware : wares) {
                int requiredAmount = this.getConstructionAmount(weapon, ware);
                if (city.getWare((IWare)ware).getAmount() >= requiredAmount) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            iterator.remove();
        }
    }

    private void filterCapability(List<EWeapon> producableWeapons, double experience) {
        producableWeapons.removeIf(weapon -> experience < this.getMinExperience((EWeapon)weapon));
    }

    private double getMinExperience(EWeapon weapon) {
        switch (weapon) {
            case BALLISTA_BIG: {
                return this.ballistaBigMinExperiance;
            }
            case BALLISTA_SMALL: {
                return this.ballistaSmallMinExperiance;
            }
            case BOMBARD: {
                return this.bombardMinExperiance;
            }
            case BOW: {
                return this.bowMinExperiance;
            }
            case CANNON: {
                return this.canonMinExperiance;
            }
            case CROSSBOW: {
                return this.crossbowMinExperiance;
            }
            case HAND_WEAPON: {
                return this.cutlassMinExperiance;
            }
            case MUSKET: {
                return this.musketMinExperiance;
            }
            case SWORD: {
                return this.swordMinExperiance;
            }
            case TREBUCHET_BIG: {
                return this.trebuchetBigMinExperiance;
            }
            case TREBUCHET_SMALL: {
                return this.trebuchetSmallMinExperiance;
            }
        }
        return Double.MAX_VALUE;
    }

    private int getConstructionAmount(EWeapon weapon, EWare ware) {
        switch (weapon) {
            case BALLISTA_BIG: {
                return (int)Math.rint((double)this.getConstructionAmount(EWeapon.BALLISTA_SMALL, ware) * 1.5);
            }
            case BALLISTA_SMALL: {
                switch (ware) {
                    case WOOD: {
                        return 4;
                    }
                    case LEATHER: {
                        return 3;
                    }
                    case IRON: {
                        return 10;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case BOMBARD: {
                switch (ware) {
                    case WOOD: {
                        return 3;
                    }
                    case LEATHER: {
                        return 2;
                    }
                    case IRON: {
                        return 15;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case BOW: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 1;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case CANNON: {
                switch (ware) {
                    case WOOD: {
                        return 3;
                    }
                    case LEATHER: {
                        return 2;
                    }
                    case IRON: {
                        return 20;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case CROSSBOW: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 2;
                    }
                    case HEMP: {
                        return 1;
                    }
                }
                return 0;
            }
            case HAND_WEAPON: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 1;
                    }
                    case HEMP: {
                        return 0;
                    }
                }
                return 0;
            }
            case MUSKET: {
                switch (ware) {
                    case WOOD: {
                        return 1;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 5;
                    }
                    case HEMP: {
                        return 0;
                    }
                }
                return 0;
            }
            case SWORD: {
                switch (ware) {
                    case WOOD: {
                        return 0;
                    }
                    case LEATHER: {
                        return 1;
                    }
                    case IRON: {
                        return 2;
                    }
                    case HEMP: {
                        return 0;
                    }
                }
                return 0;
            }
            case TREBUCHET_BIG: {
                return (int)Math.rint((double)this.getConstructionAmount(EWeapon.TREBUCHET_SMALL, ware) * 1.5);
            }
            case TREBUCHET_SMALL: {
                switch (ware) {
                    case WOOD: {
                        return 3;
                    }
                    case LEATHER: {
                        return 5;
                    }
                    case IRON: {
                        return 8;
                    }
                    case HEMP: {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    private int getBuildDuration(EWeapon weapon) {
        switch (weapon) {
            case SWORD: {
                return this.swordDuration;
            }
            case BALLISTA_BIG: {
                return this.ballistaBigDuration;
            }
            case BALLISTA_SMALL: {
                return this.ballistaSmallDuration;
            }
            case BOMBARD: {
                return this.bombardDuration;
            }
            case BOW: {
                return this.bowDuration;
            }
            case CANNON: {
                return this.canonDuration;
            }
            case CROSSBOW: {
                return this.crossbowDuration;
            }
            case HAND_WEAPON: {
                return this.cutlassDuration;
            }
            case MUSKET: {
                return this.musketDuration;
            }
            case TREBUCHET_BIG: {
                return this.trebuchetBigDuration;
            }
            case TREBUCHET_SMALL: {
                return this.trebuchetSmallDuration;
            }
        }
        return 0;
    }

    private static class WeaponAvailabilityComparator
    implements Comparator<EWeapon> {
        private final IArmory armory;

        public WeaponAvailabilityComparator(IArmory armory) {
            this.armory = armory;
        }

        @Override
        public int compare(EWeapon w1, EWeapon w2) {
            return this.getAmount(w1) - this.getAmount(w2);
        }

        private int getAmount(EWeapon weapon) {
            switch (weapon) {
                case SWORD: {
                    return this.armory.swordAmountProperty().get();
                }
                case BALLISTA_BIG: {
                    return this.armory.ballistaBigAmountProperty().get();
                }
                case BALLISTA_SMALL: {
                    return this.armory.ballistaSmallAmountProperty().get();
                }
                case BOMBARD: {
                    return this.armory.bombardAmountProperty().get();
                }
                case BOW: {
                    return this.armory.bowAmountProperty().get();
                }
                case CANNON: {
                    return this.armory.canonAmountProperty().get();
                }
                case CROSSBOW: {
                    return this.armory.crossbowAmountProperty().get();
                }
                case HAND_WEAPON: {
                    return this.armory.cutlassAmountProperty().get();
                }
                case MUSKET: {
                    return this.armory.musketAmountProperty().get();
                }
                case TREBUCHET_BIG: {
                    return this.armory.trebuchetBigAmountProperty().get();
                }
                case TREBUCHET_SMALL: {
                    return this.armory.trebuchetSmallAmountProperty().get();
                }
            }
            return 0;
        }
    }
}

