/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city;

import ch.sahits.game.openpatrician.clientserverinterface.service.CityProductionAndConsumptionService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ReputationCalculator {
    @Autowired
    private PopulationConsume consumer;
    @Autowired
    private CityProductionAndConsumptionService cityProductionAndConsumptionService;

    public int calculateWareReputation(ICity city, IPlayer player) {
        double reputation = 0.0;
        EWare[] wares = EWare.values();
        double negativeFactor = this.getNegativeReputationFactor(player, city);
        for (EWare ware : wares) {
            int cityProduction;
            double need = this.consumer.getNeed((IWare)ware, EPopulationClass.POOR, city.getPopulation(EPopulationClass.POOR));
            need += this.consumer.getNeed((IWare)ware, EPopulationClass.MEDIUM, city.getPopulation(EPopulationClass.MEDIUM));
            if (!((need += this.consumer.getNeed((IWare)ware, EPopulationClass.RICH, city.getPopulation(EPopulationClass.RICH))) > (double)(cityProduction = this.cityProductionAndConsumptionService.getProductionOutputCurrentWeek((IWare)ware, city)))) continue;
            int contribution = city.getContribution(player, (IWare)ware);
            if (contribution > 0) {
                if ((double)contribution > need) {
                    reputation += 100.0;
                    continue;
                }
                reputation += (double)contribution / need * 100.0;
                continue;
            }
            int inStorage = city.getWare((IWare)ware).getAmount();
            if (inStorage >= 20) continue;
            if (contribution == 0) {
                reputation += -100.0 * negativeFactor;
                continue;
            }
            if (contribution >= 0 || !(need > 0.0)) continue;
            reputation += Math.min(-100.0, (double)contribution / need * 100.0) * negativeFactor;
        }
        return (int)Math.rint(reputation / (double)wares.length);
    }

    @VisibleForTesting
    double getNegativeReputationFactor(IPlayer player, ICity city) {
        if (city.equals(player.getHometown())) {
            return 1.0;
        }
        if (!city.hasBuildingPermission(player)) {
            return 0.05;
        }
        if (!player.findTradingOffice(city).isPresent()) {
            return 0.12;
        }
        int nbBuildings = player.findBuildings(city).size();
        if (nbBuildings == 1) {
            return 0.18;
        }
        if (nbBuildings <= 10) {
            return 0.3;
        }
        if (nbBuildings <= 20) {
            return 0.6;
        }
        if (nbBuildings <= 30) {
            return 0.8;
        }
        return 1.0;
    }

    public double remapReputation(ICity city, IPlayer player) {
        int reputation = city.getReputation(player).getPopularity();
        return reputation < 1 ? 0.0 : Math.log10(reputation);
    }

    public ICareer calculateCareer(ICity city, IPlayer player) {
        ESocialRank rank = player.getRank();
        int nbAvailableLevels = this.getAvailableLevels(rank, player);
        double totalReputationDelta = this.calculateDelta(rank);
        double reputation = this.remapReputation(city, player);
        double startLevelRep = rank.getSocialRank();
        double reqiredRepTillNextRank = Math.max(reputation - startLevelRep, 0.0);
        double percentage = reqiredRepTillNextRank / totalReputationDelta;
        int index = (int)Math.rint((double)nbAvailableLevels * percentage);
        if (player.getCriminalDrive() > 0) {
            return EMilitantCareer.values()[rank.getCareerLowerOffset() + index];
        }
        return EEconomicCareer.values()[rank.getCareerLowerOffset() + index];
    }

    @VisibleForTesting
    double calculateDelta(ESocialRank rank) {
        if (rank == ESocialRank.ALDERMAN) {
            return this.calculateDelta(ESocialRank.MAYOR);
        }
        double upperEnd = rank.getNextRank().getSocialRank();
        return upperEnd - rank.getSocialRank();
    }

    @VisibleForTesting
    int getAvailableLevels(ESocialRank rank, IPlayer player) {
        int total = player.getCriminalDrive() > 0 ? EMilitantCareer.values().length : EEconomicCareer.values().length;
        total -= rank.getCareerLowerOffset();
        return total -= rank.getCareerUpperOffset();
    }
}

