/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.land.city.internal;

import ch.sahits.game.openpatrician.event.data.AuctionBid;
import ch.sahits.game.openpatrician.event.data.AuctionBidLevel;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.EBidLevel;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.utilities.CancelableRunnable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class NextBidTask
implements CancelableRunnable {
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Random rnd;
    private final IAuction auction;
    private boolean run = true;

    public NextBidTask(IAuction auction) {
        this.auction = auction;
    }

    public void run() {
        if (this.run) {
            boolean aiBid;
            int nextBid = this.auction.getCurrentBid() + 500;
            EBidLevel bidLevel = this.auction.getBidLevel();
            ArrayList biddingPlayers = new ArrayList(this.auction.getBiddingPlayers());
            biddingPlayers.remove(this.auction.getBiddingPlayer());
            boolean bl = aiBid = this.rnd.nextInt(2) % 2 == 0 || bidLevel == EBidLevel.INITIAL;
            if (aiBid && !biddingPlayers.isEmpty()) {
                Collections.shuffle(biddingPlayers);
                IAIPlayer bidder = (IAIPlayer)biddingPlayers.get(0);
                this.clientServerEventBus.post((Object)new AuctionBid((IPlayer)bidder, nextBid, this.auction));
            } else {
                EBidLevel nextLevel;
                switch (bidLevel) {
                    case ONE: {
                        nextLevel = EBidLevel.TWO;
                        break;
                    }
                    case TWO: {
                        nextLevel = EBidLevel.DONE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Levels " + EBidLevel.INITIAL + " and " + EBidLevel.DONE + " are not valid");
                    }
                }
                this.clientServerEventBus.post((Object)new AuctionBidLevel(bidLevel, nextLevel, this.auction.getBiddingPlayer(), this.auction));
            }
        }
    }

    public void cancel() {
        this.run = false;
    }
}

