/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player;

import ch.sahits.game.openpatrician.clientserverinterface.service.CityProductionAndConsumptionService;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapProxy;
import ch.sahits.game.openpatrician.engine.player.CityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.sea.BlockadeState;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.IgnoreOnDeserialisation;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ProductionConsumptionKnowledge
implements IProductionConsumptionKnowledge {
    @MapType(key=ICity.class, value=ICityProductionConsumptionKnowledge.class)
    private Map<ICity, ICityProductionConsumptionKnowledge> productionAndConsumption = new HashMap<ICity, ICityProductionConsumptionKnowledge>();
    @Autowired
    @XStreamOmitField
    private CityProductionAndConsumptionService productionAndConsumptionService;
    @Autowired
    private IMap map;
    @Autowired
    @XStreamOmitField
    private ApplicationContext context;
    @Autowired
    @XStreamOmitField
    private PopulationConsume consume;
    @Autowired
    private BlockadeState blockade;
    @Autowired
    @XStreamOmitField
    private MapProxy proxy;

    @PostConstruct
    @IgnoreOnDeserialisation
    private void init() {
        for (ICity city : this.map.getCities()) {
            CityProductionConsumptionKnowledge cityKnoledge = (CityProductionConsumptionKnowledge)this.context.getBean(CityProductionConsumptionKnowledge.class);
            for (EWare ware : EWare.values()) {
                int amount = this.productionAndConsumptionService.getProductionOutputCurrentWeek((IWare)ware, city);
                cityKnoledge.updateProduction((IWare)ware, amount);
                amount = this.consume.getBasicWeeklyConsumtion((IWare)ware);
                cityKnoledge.updateConsumption((IWare)ware, amount);
            }
            this.productionAndConsumption.put(city, cityKnoledge);
        }
    }

    public void updateKnowledge(ICity city) {
        CityProductionConsumptionKnowledge knowledge = (CityProductionConsumptionKnowledge)this.productionAndConsumption.get(city);
        for (EWare ware : EWare.values()) {
            int amount = this.productionAndConsumptionService.getProductionOutputCurrentWeek((IWare)ware, city);
            knowledge.updateProduction((IWare)ware, amount);
            amount = (int)Math.floor(this.consume.getWeeklyConsumption((IWare)ware, city));
            knowledge.updateConsumption((IWare)ware, amount);
            amount = city.getWare((IWare)ware).getAmount();
            knowledge.updateStored((IWare)ware, amount);
        }
    }

    public ICityProductionConsumptionKnowledge getKnowlege(ICity city) {
        Preconditions.checkNotNull((Object)city, (Object)"The city must not be null");
        return this.productionAndConsumption.get(city);
    }

    public List<ICity> findListWithProductionsMinimalDistance(ICity distanceToCity, IWare ware, INavigableVessel vessel) {
        TreeMap<Double, ICity> cityMap = new TreeMap<Double, ICity>();
        List reachableCities = this.proxy.getAllReachableNonBlockadedCities(vessel);
        double mapWidth = this.map.getDimension().getWidth();
        for (ICity city : this.productionAndConsumption.keySet()) {
            if (city.equals(distanceToCity)) continue;
            int productionAmount = this.productionAndConsumption.get(city).getProductionAmount(ware);
            double distance = distanceToCity.getCoordinates().distance(city.getCoordinates());
            double distanceFactor = distance / mapWidth;
            if (!reachableCities.contains(city)) continue;
            cityMap.put(1.0 / (distanceFactor * (double)productionAmount), city);
        }
        return cityMap.values().stream().collect(Collectors.toList());
    }

    public List<ICity> findListWithConsumptionMinimalDistance(ICity distanceToCity, IWare ware, INavigableVessel vessel) {
        TreeMap<Double, ICity> cityMap = new TreeMap<Double, ICity>();
        List reachableCities = this.proxy.getAllReachableNonBlockadedCities(vessel);
        double mapWidth = this.map.getDimension().getWidth();
        for (ICity city : this.productionAndConsumption.keySet()) {
            if (city.equals(distanceToCity)) continue;
            int consumptionAmount = this.productionAndConsumption.get(city).getConsumptionAmount(ware);
            double distance = distanceToCity.getCoordinates().distance(city.getCoordinates());
            double distanceFactor = distance / mapWidth;
            if (!reachableCities.contains(city)) continue;
            cityMap.put(1.0 / (distanceFactor * (double)consumptionAmount), city);
        }
        return cityMap.values().stream().collect(Collectors.toList());
    }

    public List<ICity> findCitiesWithNeedMinimalDistance(ICity distanceToCity, IWare ware, INavigableVessel vessel) {
        TreeMap<Double, ICity> cityMap = new TreeMap<Double, ICity>();
        double mapWidth = this.map.getDimension().getWidth();
        List reachableCities = this.proxy.getAllReachableCities(vessel);
        for (ICity city : this.productionAndConsumption.keySet()) {
            if (city.equals(distanceToCity)) continue;
            int productionAmount = this.productionAndConsumption.get(city).getProductionAmount(ware);
            int consumtionAmount = this.productionAndConsumption.get(city).getConsumptionAmount(ware);
            double consumedRation = productionAmount - consumtionAmount;
            double distance = distanceToCity.getCoordinates().distance(city.getCoordinates());
            double distanceFactor = distance / mapWidth;
            if (!reachableCities.contains(city)) continue;
            cityMap.put(1.0 / (distanceFactor * consumedRation), city);
        }
        return Lists.reverse(cityMap.values().stream().collect(Collectors.toList()));
    }
}

