/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.DynamicTradeRouteMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import javafx.geometry.Point2D;
import javafx.util.Pair;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DynamicTradeRouteStrategy
extends BasePlayerTradeStrategy {
    private static final IWare[] tradableWares = new IWare[]{EWare.WINE, EWare.SPICE, EWare.FUR, EWare.FISH_OIL};
    @Autowired
    private ShipService shipService;

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        Pair<ICity, IWare> pair = this.findClosestCityProducingTradableWare(player, vessel);
        Optional optCity = this.shipService.findCity(vessel);
        if (optCity.isPresent()) {
            if (((ICity)optCity.get()).equals(pair.getKey())) {
                this.handleBuyWaresInStartCity(player, vessel, (ICity)optCity.get());
            } else {
                this.handleBuyWaresReturnToStartCity(player, vessel, (ICity)optCity.get(), (ICity)pair.getKey());
            }
        } else {
            TravelToTradeStep travelTo = this.createTravelToStep(vessel, (ICity)pair.getKey());
            this.append(player, vessel, travelTo);
        }
        DynamicTradeRouteMissionData missionData = new DynamicTradeRouteMissionData();
        missionData.setWare((IWare)pair.getValue());
        player.setTradeMission(vessel, (ITradeMissionData)missionData);
    }

    @VisibleForTesting
    void handleBuyWaresInStartCity(IAIPlayer player, INavigableVessel vessel, ICity city) {
        IProductionConsumptionKnowledge globalKnowledge = player.getProductionAndConsumptionKnowledge();
        DynamicTradeRouteMissionData missionData = (DynamicTradeRouteMissionData)player.getTradeMission(vessel);
        ICity nextStop = this.findNextStopForBuying(city, globalKnowledge, Collections.singletonList(missionData.getWare()), vessel, city);
        HashSet<IWare> buyWares = new HashSet<IWare>();
        buyWares.add(missionData.getWare());
        this.addDefaultTradeSteps(vessel, player, city, nextStop, new HashSet<IWare>(), buyWares, false);
    }

    @VisibleForTesting
    void handleBuyWaresReturnToStartCity(IAIPlayer player, INavigableVessel vessel, ICity city, ICity startCity) {
        this.addDefaultTradeSteps(vessel, player, city, startCity, new HashSet<IWare>(), new HashSet<IWare>(), false);
    }

    @VisibleForTesting
    Pair<ICity, IWare> findClosestCityProducingTradableWare(IAIPlayer player, INavigableVessel vessel) {
        TreeMap<Double, Pair> distances = new TreeMap<Double, Pair>();
        Point2D location = vessel.getLocation();
        for (IWare ware : tradableWares) {
            ICity city = this.findCitySupplyingWare(player, ware, vessel, new HashSet<ICity>());
            double distance = location.distance(city.getCoordinates());
            Pair pair = new Pair((Object)city, (Object)ware);
            distances.put(distance, pair);
        }
        return (Pair)distances.pollFirstEntry().getValue();
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            ICity city = event.getCity();
            IProductionConsumptionKnowledge globalKnowledge = player.getProductionAndConsumptionKnowledge();
            DynamicTradeRouteMissionData missionData = (DynamicTradeRouteMissionData)player.getTradeMission(vessel);
            int wareAmount = vessel.getWare(missionData.getWare()).getAmount();
            if (wareAmount > 0) {
                List<IWare> wareOfInterest = Collections.singletonList(missionData.getWare());
                ICity nextStop = this.findNextStopForSelling(city, globalKnowledge, wareOfInterest, vessel, city);
                this.addDefaultTradeSteps(vessel, player, city, nextStop, new HashSet<IWare>(), new HashSet<IWare>(), false);
            } else {
                Pair<ICity, IWare> pair = this.findClosestCityProducingTradableWare(player, vessel);
                missionData.setWare((IWare)pair.getValue());
                this.handleBuyWaresReturnToStartCity(player, vessel, city, (ICity)pair.getKey());
            }
        }
    }
}

