/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.CentralStorageDeliveryTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CheapProductionTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectionWaresStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.DynamicTradeRouteStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.ProductionChainTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.SupplyCentralTradingStationAIStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.SupplyHometownAIStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.TradeRouteTradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public enum EAITradeStrategyType implements IAITradeStrategyType
{
    CHEAP_PRODUCTION(CheapProductionTradeStrategy.class),
    TRADE_ROUTE(TradeRouteTradeStrategy.class),
    DYNAMIC_TRADE_ROUTE(DynamicTradeRouteStrategy.class),
    PRODUCTION_CHAIN(ProductionChainTradeStrategy.class),
    SUPPLY_HOMETOWN(SupplyHometownAIStrategy.class),
    COLLECT_WARES_FOR_STORAGE_LOCATION(SupplyCentralTradingStationAIStrategy.class),
    DELIVER_WARES_FROM_CENTRAL_STORAGE(CentralStorageDeliveryTradeStrategy.class),
    COLLECT_WARES(CollectionWaresStrategy.class);

    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAITradeStrategy> strategyClass;

    private EAITradeStrategyType(Class<? extends IAITradeStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public IAITradeStrategy getStrategy() {
        return (IAITradeStrategy)this.context.getBean(this.strategyClass);
    }
}

