/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.BaseJoinGuildStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class NearTradingOfficeJoinGuildMinCashStrategy
extends BaseJoinGuildStrategy {
    private static final int MAX_DISTANCE_IN_KM = 100;
    private double maxDistanceInPixels;
    @Autowired
    private IMap map;

    @PostConstruct
    void init() {
        this.maxDistanceInPixels = 100.0 * this.map.getNumberOfPixelPerKilometer();
    }

    @Override
    protected boolean additionalJoinRequirementsMet(IAIPlayer player, ICity city, Optional<INavigableVessel> vessel) {
        for (ICity otherCity : this.map.getCities()) {
            double distance;
            Optional optOffice = player.findTradingOffice(otherCity);
            if (!optOffice.isPresent() || !((distance = otherCity.getCoordinates().distance(city.getCoordinates())) < this.maxDistanceInPixels)) continue;
            return true;
        }
        return false;
    }
}

