/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.MapProxy;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.ProductionChainMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyWeaponTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireDismissTradeManagerTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.UpgradeShipTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.product.ProductionChain;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ProductionChainTradeStrategy
extends BasePlayerTradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @XStreamOmitField
    private ProductionChain productionChain;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private MapService mapService;
    @Autowired
    @XStreamOmitField
    private MapProxy mapProxy;

    public ProductionChainTradeStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.PRODUCTION_CHAIN;
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        List waresWithProductionChain = this.productionChain.getWaresWithProductionChain();
        waresWithProductionChain.remove(EWare.BRICK);
        waresWithProductionChain.remove(EWare.PITCH);
        waresWithProductionChain.remove(EWare.LEATHER);
        ICity currentLocation = this.getCurrentCity(vessel);
        ICity productionLocation = null;
        IWare ware = null;
        block0: while (productionLocation == null) {
            Collections.shuffle(waresWithProductionChain);
            ware = (IWare)waresWithProductionChain.get(0);
            for (IWare good : currentLocation.getEffectiveProduction()) {
                if (!ware.equals(good)) continue;
                productionLocation = currentLocation;
                break;
            }
            if (productionLocation != null) continue;
            for (ICity city : this.mapProxy.getAllCities()) {
                for (IWare good : city.getEffectiveProduction()) {
                    if (!ware.equals(good)) continue;
                    productionLocation = city;
                    break;
                }
                if (productionLocation == null) continue;
                continue block0;
            }
        }
        ProductionChainMissionData missionData = new ProductionChainMissionData();
        missionData.setProduceWare(ware);
        missionData.setProductionLocation(productionLocation);
        player.setTradeMission(vessel, (ITradeMissionData)missionData);
        List requiredWares = this.productionChain.getRequiredWares(ware);
        boolean findAllHere = true;
        for (IWare requiredWare : requiredWares) {
            if (this.mapService.produces(currentLocation, requiredWare)) continue;
            findAllHere = false;
            break;
        }
        if (findAllHere && !currentLocation.equals(productionLocation)) {
            AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, currentLocation, requiredWares);
            this.append(player, vessel, buyStepHometown);
            UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
            this.append(player, vessel, upgradeShipStep);
            CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, currentLocation);
            this.append(player, vessel, repairStep);
            HireSailorsStep hireSailors = this.createHireSailorStep(vessel, currentLocation);
            this.append(player, vessel, hireSailors);
            TravelToTradeStep travelTo = this.createTravelToStep(vessel, productionLocation);
            this.append(player, vessel, travelTo);
        } else {
            IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
            HashSet<ICity> excludeCities = new HashSet<ICity>();
            excludeCities.add(currentLocation);
            ICity destination = this.findDestinationToBuyRequiredProductionWares(player, requiredWares, vessel, excludeCities);
            this.buyWaresAndTravelToNextStop(player, vessel, currentLocation, knowledge, destination);
        }
    }

    private void buyWaresAndTravelToNextStop(IAIPlayer player, INavigableVessel vessel, ICity currentLocation, IProductionConsumptionKnowledge knowledge, ICity nextStop) {
        ICityProductionConsumptionKnowledge cityKnowledge = knowledge.getKnowlege(nextStop);
        List<Pair<IWare, Number>> sortedNeedsHometown = this.getMostNeededWares(cityKnowledge, vessel);
        ArrayList<IWare> waresOfInterestNextStop = this.findWaresOfInterest(sortedNeedsHometown);
        AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, currentLocation, waresOfInterestNextStop);
        this.append(player, vessel, buyStepHometown);
        UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
        this.append(player, vessel, upgradeShipStep);
        CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, currentLocation);
        this.append(player, vessel, repairStep);
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, currentLocation);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
        this.append(player, vessel, travelTo);
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            ICity nextStop;
            List<IWare> sellWares;
            ICity city = event.getCity();
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            ProductionChainMissionData missionData = this.getMissionData(player, vessel);
            boolean inProductionTown = missionData.getProductionLocation().equals(city);
            IWare produceWare = missionData.getProduceWare();
            LinkedList<IWare> requiredWares = new LinkedList<IWare>();
            requiredWares.addAll(this.productionChain.getRequiredWares(produceWare));
            IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
            ArrayList<IWare> buyWares = new ArrayList<IWare>();
            if (inProductionTown) {
                sellWares = this.getLoadedWares(vessel);
                HashSet<ICity> excludeCities = new HashSet<ICity>();
                excludeCities.add(city);
                nextStop = this.findDestinationToBuyRequiredProductionWares(player, requiredWares, vessel, excludeCities);
                ICityProductionConsumptionKnowledge cityKnowledge = knowledge.getKnowlege(nextStop);
                if (this.isNeeded(cityKnowledge, produceWare)) {
                    buyWares.addAll(this.getWaresNeedIn(knowledge, knowledge.getKnowlege(city), nextStop));
                    if (!buyWares.contains(produceWare)) {
                        buyWares.add(produceWare);
                    }
                } else {
                    nextStop = (ICity)knowledge.findCitiesWithNeedMinimalDistance(city, produceWare, vessel).get(0);
                    buyWares.addAll(this.getWaresNeedIn(knowledge, knowledge.getKnowlege(city), nextStop));
                    if (!buyWares.contains(produceWare)) {
                        buyWares.add(produceWare);
                    }
                }
            } else {
                sellWares = new LinkedList<IWare>();
                sellWares.addAll(this.getLoadedWares(vessel));
                sellWares.removeAll(requiredWares);
                ICityProductionConsumptionKnowledge cityKnowledge = knowledge.getKnowlege(city);
                LinkedList<IWare> loadedWares = new LinkedList<IWare>();
                loadedWares.addAll(this.getLoadedWares(vessel));
                requiredWares.removeAll(loadedWares);
                ArrayList<IWare> canSupply = new ArrayList<IWare>();
                for (IWare requiredWare : requiredWares) {
                    int consumtion;
                    int production = cityKnowledge.getProductionAmount(requiredWare);
                    if (production - (consumtion = cityKnowledge.getConsumptionAmount(requiredWare)) <= 0) continue;
                    canSupply.add(requiredWare);
                }
                requiredWares.removeAll(canSupply);
                if (requiredWares.isEmpty()) {
                    nextStop = missionData.getProductionLocation();
                    buyWares.addAll(this.getWaresNeedIn(knowledge, knowledge.getKnowlege(city), nextStop));
                    buyWares.addAll(canSupply);
                } else {
                    HashSet<ICity> excludeCities = new HashSet<ICity>();
                    excludeCities.add(city);
                    nextStop = this.findDestinationToBuyRequiredProductionWares(player, requiredWares, vessel, excludeCities);
                    this.logger.debug("Add buy steps for city {} ", (Object)city.getName());
                    buyWares.addAll(this.getWaresNeedIn(knowledge, knowledge.getKnowlege(city), nextStop));
                }
            }
            if (inProductionTown) {
                AggregatesDumpTradeStep dumpStep = this.createAggregatedDumpStep(vessel, city, sellWares);
                this.append(player, vessel, dumpStep);
            } else {
                AggregatesSellTradeStep sellStep = this.createAggregatedSellStep(vessel, city, sellWares);
                this.append(player, vessel, sellStep);
            }
            PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, city);
            this.append(player, vessel, payBackLoan);
            CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, city, player);
            this.append(player, vessel, hireCaptain);
            GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, city, player);
            this.append(player, vessel, joinTradeStep);
            HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(city, player);
            this.append(player, vessel, hireTradeManager);
            TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, city);
            this.append(player, vessel, takeLoanStep);
            BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, city);
            this.append(player, vessel, buyWeaponsStep);
            AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, city, buyWares);
            this.append(player, vessel, buyStepHometown);
            UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
            this.append(player, vessel, upgradeShipStep);
            CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, city);
            this.append(player, vessel, repairStep);
            HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
            this.append(player, vessel, hireSailors);
            TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
            this.append(player, vessel, travelTo);
            this.executeTradeSteps(player, vessel);
        }
    }

    private ICity getCurrentCity(INavigableVessel vessel) {
        Optional optCity = this.shipService.findCity(vessel);
        if (!optCity.isPresent()) {
            this.logger.debug("The vessel {} is not in any city but {}", (Object)vessel.getName(), (Object)vessel.getLocation());
        }
        return (ICity)optCity.get();
    }

    private ProductionChainMissionData getMissionData(IAIPlayer player, INavigableVessel vessel) {
        return (ProductionChainMissionData)player.getTradeMission(vessel);
    }
}

