/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.BaseShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RandomShipConstructionSelectionStrategy
extends BaseShipConstructionSelectionStrategy {
    @Autowired
    private Random rnd;

    public RandomShipConstructionSelectionStrategy(int minCash, int maxFeetSize, int maxTotalCargoCapacity) {
        super(minCash, maxFeetSize, maxTotalCargoCapacity);
    }

    public EShipType shouldBuildShipType(IAIPlayer player) {
        ICity where = this.getBuildLocation(player);
        ArrayList<EShipType> shipTypes = new ArrayList<EShipType>(Arrays.asList(where.getCityState().getShipyardState().getBuildableShipTypes()));
        return (EShipType)shipTypes.get(this.rnd.nextInt(shipTypes.size()));
    }
}

