/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.SupplyCityMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyWeaponTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireDismissTradeManagerTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TransferToOfficeTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.UpgradeShipTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.player.ICityProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class SupplyHometownAIStrategy
extends BasePlayerTradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ShipService shipService;
    @Value(value="${aiplayer.money.low}")
    private int lowMoney = 2000;
    @Autowired
    private ApplicationContext context;

    public SupplyHometownAIStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.SUPPLY_HOMETOWN;
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        ICity hometown = player.getHometown();
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        ICityProductionConsumptionKnowledge knowledgeHomeTown = knowledge.getKnowlege(hometown);
        List<Pair<IWare, Number>> sortedNeeds = this.getMostNeededWares(knowledgeHomeTown, vessel);
        ArrayList<IWare> waresOfInterest = this.findWaresOfInterest(sortedNeeds);
        SupplyCityMissionData missionData = new SupplyCityMissionData();
        missionData.setRequiredWares(waresOfInterest);
        missionData.setTargetCity(hometown);
        player.setTradeMission(vessel, (ITradeMissionData)missionData);
        this.addTradeStepsInHometownToTravelToNextCity(player, vessel);
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            ICity city = event.getCity();
            Preconditions.checkArgument((boolean)city.getCoordinates().equals((Object)vessel.getLocation()), (Object)("The vessel " + vessel.getName() + " actually is not in city " + city.getName()));
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            if (city.equals(player.getHometown())) {
                this.addTradeStepsSellingInHomeTown(player, vessel);
            } else {
                this.addTradeStepTradingNextTown(player, vessel);
            }
            this.executeTradeSteps(player, vessel);
        }
    }

    private void addTradeStepsInHometownToTravelToNextCity(IAIPlayer player, INavigableVessel vessel) {
        ICity hometown = player.getHometown();
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        ICityProductionConsumptionKnowledge knowledgeHomeTown = knowledge.getKnowlege(hometown);
        List<Pair<IWare, Number>> sortedNeeds = this.getMostNeededWares(knowledgeHomeTown, vessel);
        ArrayList<IWare> waresOfInterest = this.findWaresOfInterest(sortedNeeds);
        ICity firstStop = this.findNextStopForBuying(hometown, knowledge, waresOfInterest, vessel, hometown);
        List<IWare> deliverWare = this.getWaresNeedIn(knowledge, knowledgeHomeTown, firstStop);
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, hometown);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, hometown, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, hometown, player);
        this.append(player, vessel, joinTradeStep);
        HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(hometown, player);
        this.append(player, vessel, hireTradeManager);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, hometown);
        this.append(player, vessel, takeLoanStep);
        BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, hometown);
        this.append(player, vessel, buyWeaponsStep);
        AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, hometown, deliverWare);
        this.append(player, vessel, buyStepHometown);
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, hometown);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, firstStop);
        this.logger.debug("Add travel to step from hometown {}: {}", (Object)hometown.getName(), (Object)travelTo);
        this.append(player, vessel, travelTo);
    }

    @VisibleForTesting
    void addTradeStepsSellingInHomeTown(IAIPlayer player, INavigableVessel vessel) {
        ICity hometown = player.getHometown();
        this.logger.trace("Add sell steps of wares in hometown: {} for {}", (Object)hometown.getName(), (Object)vessel.getName());
        TransferToOfficeTradeStep transferStep = this.createTransferToOfficeTradeStep(vessel, hometown);
        this.append(player, vessel, transferStep);
        ArrayList<IWare> loadedWares = new ArrayList<IWare>(vessel.getLoadedWares());
        AggregatesDumpTradeStep sellStep1 = this.createAggregatedDumpStep(vessel, hometown, loadedWares);
        this.append(player, vessel, sellStep1);
        UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
        this.append(player, vessel, upgradeShipStep);
        CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, hometown);
        this.append(player, vessel, repairStep);
        AggregatesSellTradeStep sellStep2 = this.createAggregatedSellStep(vessel, hometown, loadedWares);
        this.append(player, vessel, sellStep2);
        this.addTradeStepsInHometownToTravelToNextCity(player, vessel);
    }

    @VisibleForTesting
    void addTradeStepTradingNextTown(IAIPlayer player, INavigableVessel vessel) {
        Optional optCity = this.shipService.findCity(vessel);
        if (!optCity.isPresent()) {
            this.logger.debug("The vessel {} is not in any city but {}", (Object)vessel.getName(), (Object)vessel.getLocation());
        }
        Preconditions.checkArgument((!((ICity)optCity.get()).equals(player.getHometown()) ? 1 : 0) != 0, (Object)"The city must not be the players hometown");
        ICity city = (ICity)optCity.get();
        ICity hometown = player.getHometown();
        List<IWare> waresOfInterest = ((SupplyCityMissionData)player.getTradeMission(vessel)).getRequiredWares();
        IProductionConsumptionKnowledge knowledge = player.getProductionAndConsumptionKnowledge();
        ICityProductionConsumptionKnowledge knowledgeCurrentTown = knowledge.getKnowlege(city);
        List<Pair<IWare, Number>> sortedNeedsHometown = this.getMostNeededWares(knowledge.getKnowlege(hometown), vessel);
        List<IWare> deliveringWares = this.getLoadedWaresToSell(vessel, waresOfInterest);
        this.logger.trace("Add sell steps of wares in other town: {} for {}", (Object)city.getName(), (Object)vessel.getName());
        AggregatesSellTradeStep sellStep = this.createAggregatedSellStep(vessel, city, deliveringWares);
        this.append(player, vessel, sellStep);
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, city);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, city, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, city, player);
        this.append(player, vessel, joinTradeStep);
        HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(city, player);
        this.append(player, vessel, hireTradeManager);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, city);
        this.append(player, vessel, takeLoanStep);
        BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, city);
        this.append(player, vessel, buyWeaponsStep);
        this.logger.trace("Add buy steps of wares in other town ({}) needed in hometown ({})  for {}", (Object)city.getName(), (Object)hometown.getName(), (Object)vessel.getName());
        AggregatedCheckedBuyTradeStep buyStep = this.createAggregatedCheckedBuyTradeStep(vessel, city, waresOfInterest);
        this.append(player, vessel, buyStep);
        if (this.shouldReturnToHometown(player, vessel)) {
            HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
            this.append(player, vessel, hireSailors);
            TravelToTradeStep travelTo = this.createTravelToStep(vessel, hometown);
            this.logger.debug("Add travel to step from {} back: {}", (Object)city.getName(), (Object)travelTo);
            this.append(player, vessel, travelTo);
        } else {
            ArrayList<IWare> waresOfInterestHometown = this.findWaresOfInterest(sortedNeedsHometown);
            ICity nextStop = this.findNextStopForBuying(city, knowledge, waresOfInterestHometown, vessel, hometown);
            List<IWare> deliverWare = this.getWaresNeedIn(knowledge, knowledgeCurrentTown, nextStop);
            this.logger.trace("Add buy steps of wares in other town ({}) needed in next town ({})  for {}", (Object)city.getName(), (Object)nextStop.getName(), (Object)vessel.getName());
            AggregatedCheckedBuyTradeStep buyStepNextStop = this.createAggregatedCheckedBuyTradeStep(vessel, city, deliverWare);
            this.append(player, vessel, buyStepNextStop);
            HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
            this.append(player, vessel, hireSailors);
            TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
            StringBuilder neededInHomeTown = new StringBuilder();
            for (IWare ware : waresOfInterest) {
                neededInHomeTown.append(ware.name()).append(" ");
            }
            StringBuilder sellWares = new StringBuilder();
            for (IWare ware : deliverWare) {
                sellWares.append(ware.name()).append(" ");
            }
            this.logger.debug("Add travel to step from {}: {}, needed in hometown: {}, deliver wares {}", (Object)city.getName(), (Object)travelTo, (Object)neededInHomeTown.toString(), (Object)sellWares.toString());
            this.append(player, vessel, travelTo);
        }
    }

    @VisibleForTesting
    boolean shouldReturnToHometown(IAIPlayer player, INavigableVessel vessel) {
        if (player.getCompany().getCash() < (long)this.lowMoney) {
            return true;
        }
        List<IWare> waresOfInterest = ((SupplyCityMissionData)player.getTradeMission(vessel)).getRequiredWares();
        if (vessel.getCapacity() == 0) {
            for (EWare ware : EWare.values()) {
                if (vessel.getWare((IWare)ware).getAmount() <= 0 || waresOfInterest.contains(ware)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    List<IWare> getLoadedWaresToSell(INavigableVessel vessel, List<IWare> waresOfInterest) {
        ArrayList<IWare> wares = new ArrayList<IWare>();
        for (IWare ware : vessel.getLoadedWares()) {
            if (waresOfInterest.contains(ware)) continue;
            wares.add(ware);
        }
        return wares;
    }
}

