/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.engine.player.TradeRouteMissionData;
import ch.sahits.game.openpatrician.engine.player.strategy.BasePlayerTradeStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.EAITradeStrategyType;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatedCheckedBuyTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesDumpTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.AggregatesSellTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.BuyWeaponTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckForRepairTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.CheckHireCaptainTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.GuildJoinTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireDismissTradeManagerTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.HireSailorsStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.PayBackLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TakeLoanTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.TravelToTradeStep;
import ch.sahits.game.openpatrician.engine.player.tradesteps.UpgradeShipTradeStep;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.IShipEntersPortEvent;
import ch.sahits.game.openpatrician.model.map.ITradeRoute;
import ch.sahits.game.openpatrician.model.map.ITradeRouteStop;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TradeRouteTradeStrategy
extends BasePlayerTradeStrategy {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ShipService shipService;
    @Value(value="${aiplayer.money.low}")
    private int lowMoney = 2000;
    @Autowired
    private MapService mapService;

    public TradeRouteTradeStrategy() {
        this.tradeStrategyType = EAITradeStrategyType.TRADE_ROUTE;
    }

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void initializeTradeCycle(IAIPlayer player, INavigableVessel vessel) {
        Optional optCity = this.shipService.findCity(vessel);
        if (!optCity.isPresent()) {
            this.logger.debug("The vessel {} is not in any city but {}", (Object)vessel.getName(), (Object)vessel.getLocation());
        }
        ICity city = (ICity)optCity.get();
        ITradeMissionData missionData = player.getTradeMission(vessel);
        if (missionData == null || !(missionData instanceof TradeRouteMissionData)) {
            missionData = this.selectTradeRoute(city);
            player.setTradeMission(vessel, missionData);
        }
        ITradeRoute route = ((TradeRouteMissionData)missionData).getTradeRoute();
        List<IWare> loadedWares = this.getLoadedWares(vessel);
        if (!loadedWares.isEmpty()) {
            ICity firstCity = ((ITradeRouteStop)((TradeRouteMissionData)missionData).getTradeRoute().getTradeStops().iterator().next()).getTradeStop();
            if (firstCity.equals(city)) {
                AggregatesDumpTradeStep dumpStep = this.createAggregatedDumpStep(vessel, city, loadedWares);
                this.append(player, vessel, dumpStep);
            } else {
                AggregatesSellTradeStep sellStep = this.createAggregatedSellStep(vessel, city, loadedWares);
                this.append(player, vessel, sellStep);
            }
        }
        PayBackLoanTradeStep payBackLoan = this.createPaybackLoanStep(player, city);
        this.append(player, vessel, payBackLoan);
        CheckHireCaptainTradeStep hireCaptain = this.createHireCaptain(vessel, city, player);
        this.append(player, vessel, hireCaptain);
        GuildJoinTradeStep joinTradeStep = this.createJoinGuildTradeStep(vessel, city, player);
        this.append(player, vessel, joinTradeStep);
        HireDismissTradeManagerTradeStep hireTradeManager = this.createHireDismissTradeManagerTradeStep(city, player);
        this.append(player, vessel, hireTradeManager);
        TakeLoanTradeStep takeLoanStep = this.createCheckAndTakeLoanStep(player, city);
        this.append(player, vessel, takeLoanStep);
        BuyWeaponTradeStep buyWeaponsStep = this.createWeaponBuyTradeStep(vessel, player, city);
        this.append(player, vessel, buyWeaponsStep);
        ITradeRouteStop stop = null;
        ICity nextStop = null;
        Iterator iterator = route.getTradeStops().iterator();
        while (iterator.hasNext()) {
            ITradeRouteStop routeStop = (ITradeRouteStop)iterator.next();
            if (!routeStop.getTradeStop().equals(city)) continue;
            stop = routeStop;
            if (iterator.hasNext()) {
                routeStop = (ITradeRouteStop)iterator.next();
                nextStop = routeStop.getTradeStop();
                break;
            }
            nextStop = ((ITradeRouteStop)route.getTradeStops().iterator().next()).getTradeStop();
            break;
        }
        ArrayList<IWare> buyWares = new ArrayList<IWare>(stop.getWaresToBuy());
        AggregatedCheckedBuyTradeStep buyStepHometown = this.createAggregatedCheckedBuyTradeStep(vessel, city, buyWares);
        this.append(player, vessel, buyStepHometown);
        UpgradeShipTradeStep upgradeShipStep = this.createUpgradeShipTradeStep(vessel, player);
        this.append(player, vessel, upgradeShipStep);
        CheckForRepairTradeStep repairStep = this.createCheckRepairStep(vessel, city);
        this.append(player, vessel, repairStep);
        HireSailorsStep hireSailors = this.createHireSailorStep(vessel, city);
        this.append(player, vessel, hireSailors);
        TravelToTradeStep travelTo = this.createTravelToStep(vessel, nextStop);
        this.append(player, vessel, travelTo);
    }

    @Override
    public ICity getCityToRestartTradeCycle(INavigableVessel vessel) {
        ITradeMissionData missionData = ((IAIPlayer)vessel.getOwner()).getTradeMission(vessel);
        ITradeRoute route = ((TradeRouteMissionData)missionData).getTradeRoute();
        double distance = Double.MAX_VALUE;
        ICity destination = null;
        for (ITradeRouteStop stop : route.getTradeStops()) {
            double d = vessel.getLocation().distance(stop.getTradeStop().getCoordinates());
            if (!(d < distance)) continue;
            distance = d;
            destination = stop.getTradeStop();
        }
        return destination;
    }

    private TradeRouteMissionData selectTradeRoute(ICity city) {
        List routes = this.mapService.findTradeRoutesFirstStop(city);
        if (routes.isEmpty()) {
            routes = this.mapService.findTradeRoutesSecondStop(city);
        }
        Collections.shuffle(routes);
        ITradeRoute route = (ITradeRoute)routes.get(0);
        TradeRouteMissionData missionData = new TradeRouteMissionData();
        missionData.setTradeRoute(route);
        return missionData;
    }

    public void handleShipArrivesInPort(IShipEntersPortEvent event) {
        INavigableVessel vessel = event.getShip();
        if (this.isMatchingTradeStrategy(vessel)) {
            IAIPlayer player = (IAIPlayer)vessel.getOwner();
            this.initializeTradeCycle(player, vessel);
            this.executeTradeSteps(player, vessel);
        }
    }
}

