/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeCogWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeCrayerWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeHolkWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionTradingOfficeSnaikkaWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.CollectConstructionWareStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.IAICityDependentShipConstructionStrategy;
import ch.sahits.game.openpatrician.engine.player.strategy.RandomShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class TradingOfficeRandomShipConstructionSelectionStrategy
extends RandomShipConstructionSelectionStrategy {
    @Autowired
    private IMap map;
    @Autowired
    private Random rnd;
    @Autowired
    private ApplicationContext context;

    public TradingOfficeRandomShipConstructionSelectionStrategy() {
        super(100000, 50, 15000);
    }

    public ICity getBuildLocation(IAIPlayer player) {
        return player.getHometown();
    }

    public void initShipConstruction(IAIPlayer player, INavigableVessel vessel, EShipType shipType) {
        CollectConstructionWareStrategy strategy = null;
        ICity constructionCity = this.calculateCostructionCity(player);
        switch (shipType) {
            case HOLK: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionTradingOfficeHolkWareStrategy.class);
                break;
            }
            case COG: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionTradingOfficeCogWareStrategy.class);
                break;
            }
            case CRAYER: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionTradingOfficeCrayerWareStrategy.class);
                break;
            }
            case SNAIKKA: {
                strategy = (CollectConstructionWareStrategy)this.context.getBean(CollectConstructionTradingOfficeSnaikkaWareStrategy.class);
            }
        }
        ((IAICityDependentShipConstructionStrategy)((Object)strategy)).setConstructionCity(constructionCity);
        strategy.initializeTradeCycle(player, vessel);
    }

    @VisibleForTesting
    ICity calculateCostructionCity(IAIPlayer player) {
        List chosableCities = this.map.getCities().stream().filter(city -> player.findTradingOffice(city).isPresent()).collect(Collectors.toList());
        return (ICity)chosableCities.get(this.rnd.nextInt(chosableCities.size()));
    }
}

