/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.engine.player.tradesteps.BaseBuyTradeStep;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradeStep
extends BaseBuyTradeStep {
    private boolean executeNext = true;

    public boolean execute() {
        IPlayer player = (IPlayer)this.getVessel().getOwner();
        int maxAmount = this.getVessel().getCapacity();
        if (!this.getWare().isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        this.transferFromOfficeOrBuyFromCity(player, maxAmount);
        return this.executeNext;
    }

    public String toString() {
        return "BuyTradeStep{Buy " + this.getWare() + " for " + this.getVessel().getName() + " in " + this.getCity().getName() + " for a max price of" + this.getMaxBuyPrice() + "}";
    }

    protected void setExecuteNext(boolean executeNext) {
        this.executeNext = executeNext;
    }
}

