/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class UpgradeShipTradeStep
implements ITradeStep {
    private INavigableVessel vessel;
    private IAIPlayer player;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;

    public boolean execute() {
        if (this.vessel instanceof IShip) {
            IShip ship = (IShip)this.vessel;
            IAIShipUpgradeStrategy strategy = (IAIShipUpgradeStrategy)this.player.getShipUpgradeStrategyType().getStrategy();
            if (strategy.shouldUpgrade(ship)) {
                ICity city = (ICity)this.shipService.findCity((INavigableVessel)ship).get();
                strategy.upgrade(ship, city);
                return false;
            }
        }
        return true;
    }

    public void setVessel(INavigableVessel vessel) {
        this.vessel = vessel;
    }

    public void setPlayer(IAIPlayer player) {
        this.player = player;
    }
}

