/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.engine.sea.AStarGraphProvider;
import ch.sahits.game.openpatrician.engine.sea.model.GraphAStar;
import ch.sahits.game.openpatrician.engine.sea.model.NodeData;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.carrotsearch.hppc.ObjectDoubleMap;
import com.carrotsearch.hppc.cursors.ObjectDoubleCursor;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javafx.geometry.Point2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
public class AStar {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private GraphAStar<Point2D> graph;
    @Autowired
    private AStarGraphProvider graphProvider;
    @Autowired
    private IMap map;
    @Autowired
    @Qualifier(value="serverThreadPool")
    private Executor serverThreadPool;
    @Autowired
    @Qualifier(value="paralleizationExecutor")
    private ExecutorService paralleizationExecutor;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @MapType(key=Point2D.class, value=Map.class)
    private Map<Point2D, Map<Point2D, List<Point2D>>> pathCache = new ConcurrentHashMap<Point2D, Map<Point2D, List<Point2D>>>();

    public List<Point2D> findPath(Point2D source, Point2D destination) {
        while (this.graph == null) {
            this.graph = this.graphProvider.getGraph();
            Thread.yield();
        }
        List<Point2D> pathList = this.findCached(destination, source);
        if (pathList != null) {
            return pathList;
        }
        this.ensureSetup(source, destination);
        PriorityQueue<NodeData<Point2D>> openQueue = new PriorityQueue<NodeData<Point2D>>(11, new NodeComparator());
        NodeData<Point2D> sourceNodeData = this.graph.getNodeData(source);
        sourceNodeData.setG(source, 0.0);
        sourceNodeData.calcF(destination, source);
        openQueue.add(sourceNodeData);
        HashMap<Point2D, Point2D> path = new HashMap<Point2D, Point2D>();
        HashSet<NodeData> closedList = new HashSet<NodeData>();
        this.logger.trace("Find path from {} -> {}", (Object)source, (Object)destination);
        while (!openQueue.isEmpty()) {
            NodeData nodeData = (NodeData)openQueue.poll();
            this.logger.trace("Inspect node: {}", nodeData.getNodeId());
            if (((Point2D)nodeData.getNodeId()).equals((Object)destination)) {
                pathList = this.path(path, destination);
                Map<Point2D, List<Point2D>> sourceMap = this.pathCache.get(destination);
                if (sourceMap == null) {
                    sourceMap = new HashMap<Point2D, List<Point2D>>();
                    sourceMap.put(source, pathList);
                    this.pathCache.put(destination, sourceMap);
                } else {
                    sourceMap.put(source, pathList);
                }
                if (this.logger.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Found path: ");
                    for (Point2D point2D : pathList) {
                        sb.append(point2D).append(" ");
                    }
                    this.logger.trace(sb.toString());
                }
                return pathList;
            }
            closedList.add(nodeData);
            ObjectDoubleMap<NodeData<Point2D>> map = this.graph.edgesFrom((Point2D)nodeData.getNodeId());
            for (ObjectDoubleCursor neighborEntry : map) {
                double distanceBetweenTwoNodes;
                double tentativeG;
                NodeData neighbor = (NodeData)neighborEntry.key;
                if (closedList.contains(neighbor) || !((tentativeG = (distanceBetweenTwoNodes = neighborEntry.value) + nodeData.getG(source)) <= neighbor.getG(source))) continue;
                neighbor.setG(source, tentativeG);
                neighbor.calcF(destination, source);
                path.put((Point2D)neighbor.getNodeId(), (Point2D)nodeData.getNodeId());
                if (openQueue.contains(neighbor)) continue;
                openQueue.add(neighbor);
                this.logger.trace("Add neighbor {}", neighbor.getNodeId());
            }
        }
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Partial path: ");
            for (NodeData nodeData : closedList) {
                sb.append(nodeData.getNodeId()).append(" ");
            }
            this.logger.trace(sb.toString());
        }
        return null;
    }

    private List<Point2D> findCached(Point2D destination, Point2D source) {
        Map<Point2D, List<Point2D>> sourceMap = this.pathCache.get(destination);
        if (sourceMap != null) {
            return sourceMap.get(source);
        }
        return null;
    }

    private void ensureSetup(Point2D source, Point2D destination) {
        boolean isCity;
        if (!this.graph.containsNode(source)) {
            isCity = false;
            for (ICity city : this.map.getCities()) {
                if (!source.equals((Object)city.getCoordinates())) continue;
                isCity = true;
                break;
            }
            this.graphProvider.addDestinationPoint(source, isCity);
        }
        if (!this.graph.containsNode(destination)) {
            isCity = false;
            for (ICity city : this.map.getCities()) {
                if (!destination.equals((Object)city.getCoordinates())) continue;
                isCity = true;
                break;
            }
            this.graphProvider.addDestinationPoint(destination, isCity);
        }
        this.graphProvider.getGraph();
    }

    private List<Point2D> path(Map<Point2D, Point2D> path, Point2D destination) {
        assert (path != null);
        assert (destination != null);
        ArrayList<Point2D> pathList = new ArrayList<Point2D>();
        pathList.add(destination);
        while (path.containsKey(destination)) {
            destination = path.get(destination);
            pathList.add(destination);
        }
        Collections.reverse(pathList);
        return pathList;
    }

    private static class NodeComparator
    implements Comparator<NodeData<Point2D>> {
        private NodeComparator() {
        }

        @Override
        public int compare(NodeData<Point2D> nodeFirst, NodeData<Point2D> nodeSecond) {
            return Double.compare(nodeFirst.getF(), nodeSecond.getF());
        }
    }
}

