/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea;

import ch.sahits.game.openpatrician.engine.sea.AStarHeuristicProvider;
import ch.sahits.game.openpatrician.engine.sea.BaseGraphCalulationService;
import ch.sahits.game.openpatrician.engine.sea.model.GraphAStar;
import ch.sahits.game.openpatrician.event.data.GraphInitialisationComplete;
import ch.sahits.game.openpatrician.event.data.HeuristicGraphInitialisationComplete;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.carrotsearch.hppc.ObjectDoubleMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javafx.geometry.Point2D;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
@Component
@Lazy
public class AStarGraphProvider
extends BaseGraphCalulationService {
    @Autowired
    private AStarHeuristicProvider heuristicProvider;
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverThreadPool")
    private Executor serverThreadPool;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private final Object lock = new Object();
    private int width;
    private int height;
    private GraphAStar<Point2D> graph;
    @MapType(key=Point2D.class, value=Map.class)
    private Map<Point2D, ObjectDoubleMap<Point2D>> heuristic;

    @PostConstruct
    private void init() {
        this.clientServerEventBus.register((Object)this);
        try {
            this.initImage();
        }
        catch (IOException e) {
            this.logger.error("Failed to create black and white image from the map", (Throwable)e);
        }
    }

    @Subscribe
    public void initGraph(HeuristicGraphInitialisationComplete event) {
        this.serverThreadPool.execute(this::createGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createGraph() {
        long timestamp = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.heuristic = this.heuristicProvider.getHeuristic();
            while (this.heuristic.size() == 0) {
                Thread.yield();
                this.heuristic = this.heuristicProvider.getHeuristic();
            }
            this.graph = new GraphAStar<Point2D>(this.heuristic);
            List cities = this.map.getCities();
            for (int x = 0; x < this.width; x += 5) {
                for (int y = 0; y < this.height; y += 5) {
                    Point2D p2;
                    Point2D p = this.getPoint(x, y);
                    if (!this.isOnSea(p)) continue;
                    if (!this.graph.containsNode(p)) {
                        this.graph.addNodeInternal(p);
                    }
                    if (x + 5 <= this.width) {
                        p2 = this.getPoint(x + 5, y);
                        this.addEdges(p, p2, false, false);
                    }
                    if (y + 5 <= this.height) {
                        p2 = this.getPoint(x, y + 5);
                        this.addEdges(p, p2, false, false);
                    }
                    if (x + 5 <= this.width && y + 5 <= this.height) {
                        p2 = this.getPoint(x + 5, y + 5);
                        this.addEdges(p, p2, false, false);
                    }
                    if (x + 5 <= this.width && y - 5 >= 0) {
                        p2 = this.getPoint(x + 5, y - 5);
                        this.addEdges(p, p2, false, false);
                    }
                    for (ICity city : cities) {
                        if (!(p.distance(city.getCoordinates()) < DIAG_CHECK_DISTANCE)) continue;
                        Point2D p22 = city.getCoordinates();
                        this.addEdges(p, p22, true, false);
                    }
                }
            }
        }
        long took = System.currentTimeMillis() - timestamp;
        this.logger.debug("Created graph taking " + took + "ms");
        this.clientServerEventBus.post((Object)new GraphInitialisationComplete());
    }

    public void addDestinationPoint(Point2D newPoint, boolean isCity) {
        this.addDestinationPointInternal(newPoint, isCity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void addDestinationPointInternal(Point2D newPoint, boolean isCity) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.heuristic.containsKey(newPoint)) {
                this.heuristicProvider.addSourceNodeToHeuristic(newPoint);
                this.heuristicProvider.addTargetNodeToHeuristic(newPoint);
                this.heuristicProvider.getHeuristic();
            }
            Preconditions.checkArgument((boolean)this.heuristic.containsKey(newPoint), (Object)("Destination not part of the heuristic: " + newPoint));
            if (this.graph.containsNode(newPoint)) {
                return;
            }
            ArrayList<Point2D> nearest = new ArrayList<Point2D>();
            for (Point2D node : this.graph) {
                double distance = node.distance(newPoint);
                if (!(distance <= DIAG_CHECK_DISTANCE)) continue;
                nearest.add(node);
            }
            this.graph.addNode(newPoint, true);
            for (Point2D point : nearest) {
                this.addEdges(newPoint, point, isCity, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void addSourcePointInternal(Point2D source, boolean isCity) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.heuristic.containsKey(source)) {
                this.heuristicProvider.addSourceNodeToHeuristic(source);
            }
            if (this.graph.containsNode(source)) {
                return;
            }
            ArrayList<Point2D> nearest = new ArrayList<Point2D>();
            for (Point2D node : this.graph) {
                double distance = node.distance(source);
                if (!(distance <= DIAG_CHECK_DISTANCE)) continue;
                nearest.add(node);
            }
            this.graph.addNode(source, false);
            for (Point2D point : nearest) {
                this.addEdges(source, point, isCity, false);
            }
        }
    }

    @Override
    protected double calculateWeight(Point2D from, Point2D to) {
        if (from.equals((Object)to)) {
            return 0.0;
        }
        double distance = from.distance(to);
        try {
            int landPixels = this.imageService.countLandPixels(to, 10, this.getSegments(from, to));
            int tangentialLandPixels = this.imageService.countLandPixels(to, (int)Math.round(DIAG_CHECK_DISTANCE), this.getTangentialSegments(from, to));
            double recastLandPixels = (double)landPixels / 27.0;
            double recastTangentialPixels = (double)tangentialLandPixels / 15.0;
            return distance + recastLandPixels + recastTangentialPixels;
        }
        catch (IOException e) {
            this.logger.error("Failed to count the land pixels near " + to, (Throwable)e);
            return distance;
        }
    }

    private void addEdges(Point2D from, Point2D to, boolean isCity, boolean initial) {
        if (isCity || this.isOnSea(to)) {
            if (!this.graph.containsNode(to)) {
                if (initial) {
                    this.graph.addNodeInternal(to);
                } else {
                    this.graph.addNode(to, true);
                }
            }
            this.heuristicProvider.getHeuristic();
            double weight = this.calculateWeight(from, to);
            if (initial) {
                this.graph.addEdgeInternal(from, to, weight);
            } else {
                this.graph.addEdge(from, to, weight);
            }
            weight = this.calculateWeight(to, from);
            if (initial) {
                this.graph.addEdgeInternal(to, from, weight);
            } else {
                this.graph.addEdge(to, from, weight);
            }
        }
    }

    @VisibleForTesting
    void initImage() throws IOException {
        this.width = this.imageService.getWidth();
        this.height = this.imageService.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphAStar<Point2D> getGraph() {
        Object object = this.lock;
        synchronized (object) {
            return this.graph;
        }
    }
}

