/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.carrotsearch.hppc.ObjectDoubleMap;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ClassCategory(value={EClassCategory.MODEL})
public final class NodeData<T> {
    private static final Logger LOGGER = LogManager.getLogger(NodeData.class);
    private final T nodeId;
    @MapType(key=Point2D.class, value=Double.class)
    private final ObjectDoubleMap<T> heuristic;
    @MapType(key=Point2D.class, value=Double.class)
    private Map<T, Double> distanceFromSource = new HashMap<T, Double>();
    private double h;
    private double f;

    public NodeData(T nodeId, ObjectDoubleMap<T> heuristic) {
        this.nodeId = nodeId;
        this.heuristic = heuristic;
    }

    public void setG(T source, double g) {
        this.distanceFromSource.put(source, g);
    }

    public double getG(T source) {
        return this.distanceFromSource.getOrDefault(source, (Double)Double.MAX_VALUE);
    }

    public void calcF(T destination, T source) {
        if (this.heuristic == null) {
            LOGGER.warn("Heuristic is null");
        }
        if (!this.heuristic.containsKey(destination)) {
            LOGGER.warn("Destination ({}) for source {} not available", destination, source);
        }
        this.h = this.heuristic.get(destination);
        this.f = this.getG(source) + this.h;
    }

    public T getNodeId() {
        return this.nodeId;
    }

    public double getH() {
        return this.h;
    }

    public double getF() {
        return this.f;
    }
}

