/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.sea.model;

import ch.sahits.game.openpatrician.model.people.ISeaPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public final class PirateActivityEntry {
    private final ISeaPirate pirate;
    private final boolean fightWon;
    private final int sukenShips;
    private final int enteredShips;
    private final int lootedShips;

    PirateActivityEntry(ISeaPirate pirate, boolean fightWon, int sukenShips, int enteredShips, int lootedShips) {
        this.pirate = pirate;
        this.fightWon = fightWon;
        this.sukenShips = sukenShips;
        this.enteredShips = enteredShips;
        this.lootedShips = lootedShips;
    }

    public static PirateActivityEntryBuilder builder() {
        return new PirateActivityEntryBuilder();
    }

    public ISeaPirate getPirate() {
        return this.pirate;
    }

    public boolean isFightWon() {
        return this.fightWon;
    }

    public int getSukenShips() {
        return this.sukenShips;
    }

    public int getEnteredShips() {
        return this.enteredShips;
    }

    public int getLootedShips() {
        return this.lootedShips;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PirateActivityEntry)) {
            return false;
        }
        PirateActivityEntry other = (PirateActivityEntry)o;
        ISeaPirate this$pirate = this.getPirate();
        ISeaPirate other$pirate = other.getPirate();
        if (this$pirate == null ? other$pirate != null : !this$pirate.equals(other$pirate)) {
            return false;
        }
        if (this.isFightWon() != other.isFightWon()) {
            return false;
        }
        if (this.getSukenShips() != other.getSukenShips()) {
            return false;
        }
        if (this.getEnteredShips() != other.getEnteredShips()) {
            return false;
        }
        return this.getLootedShips() == other.getLootedShips();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ISeaPirate $pirate = this.getPirate();
        result = result * 59 + ($pirate == null ? 43 : $pirate.hashCode());
        result = result * 59 + (this.isFightWon() ? 79 : 97);
        result = result * 59 + this.getSukenShips();
        result = result * 59 + this.getEnteredShips();
        result = result * 59 + this.getLootedShips();
        return result;
    }

    public String toString() {
        return "PirateActivityEntry(pirate=" + this.getPirate() + ", fightWon=" + this.isFightWon() + ", sukenShips=" + this.getSukenShips() + ", enteredShips=" + this.getEnteredShips() + ", lootedShips=" + this.getLootedShips() + ")";
    }

    public static class PirateActivityEntryBuilder {
        private ISeaPirate pirate;
        private boolean fightWon;
        private int sukenShips;
        private int enteredShips;
        private int lootedShips;

        PirateActivityEntryBuilder() {
        }

        public PirateActivityEntryBuilder pirate(ISeaPirate pirate) {
            this.pirate = pirate;
            return this;
        }

        public PirateActivityEntryBuilder fightWon(boolean fightWon) {
            this.fightWon = fightWon;
            return this;
        }

        public PirateActivityEntryBuilder sukenShips(int sukenShips) {
            this.sukenShips = sukenShips;
            return this;
        }

        public PirateActivityEntryBuilder enteredShips(int enteredShips) {
            this.enteredShips = enteredShips;
            return this;
        }

        public PirateActivityEntryBuilder lootedShips(int lootedShips) {
            this.lootedShips = lootedShips;
            return this;
        }

        public PirateActivityEntry build() {
            return new PirateActivityEntry(this.pirate, this.fightWon, this.sukenShips, this.enteredShips, this.lootedShips);
        }

        public String toString() {
            return "PirateActivityEntry.PirateActivityEntryBuilder(pirate=" + this.pirate + ", fightWon=" + this.fightWon + ", sukenShips=" + this.sukenShips + ", enteredShips=" + this.enteredShips + ", lootedShips=" + this.lootedShips + ")";
        }
    }
}

