package ch.sahits.game.openpatrician.engine.event;

import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.Optional;
import java.util.Random;

/**
 * Event related utility methods.
 * Created by andi on 25.03.17.
 */
@Service
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class EventService {
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public Optional<ISpouseData> calculateSpouseDeath(IPlayer player, ICity city) {
        Optional<ISpouseData> killedSpouse = Optional.empty();
        if (player.getHometown().equals(city) && player.getSpouseData().isPresent()) {
            if (rnd.nextInt(5) == 0) {
                killedSpouse = Optional.of(player.getSpouseData().get());
                player.spouseDies();
            }
        }
        return killedSpouse;
    }
    /**
     * Post a message that will end up in the message queue.
     * @param state dialog state for the display message
     * @param player player to whom the message is posted
     * @param messageKey text key of the display state message
     * @param messageParams message parameters for the message
     */
    public void postToHumanPlayer(IDialogState state, IPlayer player, String messageKey, Object... messageParams) {
        if (player instanceof IHumanPlayer) {
            DisplayStateMessage message = new DisplayStateMessage(messageKey, state, messageParams);
            clientServerEventBus.post(new TargetedEvent((IHumanPlayer) player, message));
        }
    }
}
