package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;

import java.time.LocalDateTime;

/**
 * Timed task for the church upgrade.
 * Created by andi on 26.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ChurchUpgradeTimedTask extends TimedTask {

    private IChurch church;

    public ChurchUpgradeTimedTask(IChurch church, LocalDateTime dealine) {
        this.church = church;
        setExecutionTime(dealine);
    }

    @Override
    public void run() {
        church.upgrade();
    }
}
