package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.engine.event.EventEngineState;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * Timed task for the case where the marriage offer was not accepted.
 * Created by andi on 30.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageOfferDeclinedTimedTask extends TimedTask {
    public static final int OFFER_VALID_DURATION = 75;
    @Autowired
    private Date date;
    @Autowired
    private EventEngineState eventState;

    private IPlayer player;

    public MarriageOfferDeclinedTimedTask(IPlayer player) {
        this.player = player;
    }

    @PostConstruct
    private void init() {
        setExecutionTime(date.getCurrentDate().plusDays(OFFER_VALID_DURATION));
    }

    @Override
    public void run() {
        eventState.resetMarriedState(player);
    }
}
