package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.time.LocalDateTime;

/**
 * Timed task to post a dialog through a state
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Feb 03, 2018
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PostStateDialogToHumanPlayerTask extends TimedTask {
    private final IDialogState state;
    private final IPlayer player;
    private final String messageKey;
    private final Object[] messageParams;

    @Autowired
    @Qualifier("serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public PostStateDialogToHumanPlayerTask(LocalDateTime executionTime, IDialogState state, IPlayer player, String messageKey, Object[] messageParams) {
        super();
        setExecutionTime(executionTime);
        this.state = state;
        this.player = player;
        this.messageKey = messageKey;
        this.messageParams = messageParams;
    }

    @Override
    public void run() {
        if (player instanceof IHumanPlayer) {
            DisplayStateMessage message = new DisplayStateMessage(messageKey, state, messageParams);
            clientServerEventBus.post(new TargetedEvent((IHumanPlayer) player, message));
        }
    }
}
