package ch.sahits.game.openpatrician.engine.player;

import java.util.Comparator;

/**
 * The various reasons for trading a ware.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 08, 2017
 */
public enum ETradeReason {
    /** Ware is required for production in players workshops */
    REQUIRE_FOR_PRODUCTION(true, 2),
    /** Ware is required to cover basic needs in city */
    REQUIRE_FOR_BASIC_NEEDS(false, 20),
    /** Ware is produced in players workshop */
    PRODUCED_WARE_IN_WORKSHOP(false, 30),
    /** Ware is produced in the city */
    PRODUCED_WARE_IN_CITY(true, 1),
    /** Ware is required for production in the city */
    REQUIRE_FOR_CITY_PRODUCTION(false, 10);

    private final boolean buyReason;
    private final int prio;

    ETradeReason(boolean buyReason, int prio) {
        this.buyReason = buyReason;
        this.prio = prio;
    }

    /**
     * Is the reason a buy reason.
     * @return true if it is a buy reason
     */
    public boolean isBuyReason() {
        return buyReason;
    }

    public static Comparator<ETradeReason> comparator() {
        return Comparator.comparingInt(o -> o.prio);
    }

}
