package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.ITradeStrategyHintContext;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.SetType;
import lombok.Getter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Hint context for the central storage hint.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 21, 2017
 */
@Getter
@ClassCategory({EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class CentralStorageHintContext implements ITradeStrategyHintContext {
    @ListType(INavigableVessel.class)
    private List<INavigableVessel> supplyingVessels = new ArrayList<>();
    @ListType(INavigableVessel.class)
    private List<INavigableVessel> distributingVessels = new ArrayList<>();
    @SetType(IWare.class)
    private Set<IWare> wares = new HashSet<>();
    @ListType(ICity.class)
    private List<ICity> suppliedCities = new ArrayList<>();

    public void addWare(IWare ware) {
        wares.add(ware);
    }

    public void addSupplyingVessel(INavigableVessel vessel) {
       supplyingVessels.add(vessel);
    }

    public void addDistributingVessel(INavigableVessel vessel) {
        distributingVessels.add(vessel);
    }

    public void addSuppliedCity(ICity city) {
        suppliedCities.add(city);
    }

}
