package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import lombok.Getter;
import lombok.Setter;

/**
 * This implementation for construction provides construction location in a random city with a trading office.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 30, 2016
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public abstract class CollectionConstructionTradingOfficeWaresStrategy extends CollectConstructionWareStrategy implements IAICityDependentShipConstructionStrategy {
    @Getter
    @Setter
    private ICity constructionCity;

    public CollectionConstructionTradingOfficeWaresStrategy(EShipType constructionType) {
        super(constructionType);
    }
    @Override
    protected ICity getConstructionCity(IAIPlayer player) {
        return constructionCity;
    }
}
