package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * Strategy type for the trade strategy.
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public enum EAITradeStrategyType implements IAITradeStrategyType {
    CHEAP_PRODUCTION(CheapProductionTradeStrategy.class),
    TRADE_ROUTE(TradeRouteTradeStrategy.class),
    DYNAMIC_TRADE_ROUTE(DynamicTradeRouteStrategy.class),
    PRODUCTION_CHAIN(ProductionChainTradeStrategy.class),
    SUPPLY_HOMETOWN(SupplyHometownAIStrategy.class),
    COLLECT_WARES_FOR_STORAGE_LOCATION(SupplyCentralTradingStationAIStrategy.class),
    DELIVER_WARES_FROM_CENTRAL_STORAGE(CentralStorageDeliveryTradeStrategy.class),
    COLLECT_WARES(CollectionWaresStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAITradeStrategy> strategyClass;

    EAITradeStrategyType(Class<? extends IAITradeStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAITradeStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
