package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategy;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
public enum EHireCaptainStrategyType implements IAICaptainHireStrategyType {
    HIRE_ALWAYS(HireCaptainAlwaysStrategy.class),
    HIRE_NEVER(HireCaptainNeverStrategy.class),
    HIRE_FOR_SHIPS_ABOVE_300(HireCaptainForMediumShipsStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAICaptainHireStrategy> strategyClass;

    EHireCaptainStrategyType(Class<? extends IAICaptainHireStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(org.springframework.context.ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAICaptainHireStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
