package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategy;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jun 12, 2016
 */
public enum ETakeLoanStrategyType implements IAITakeLoanStrategyType {
    LOW_MONEY_LONG_DURATION(TakeLoanLowMoneyLongestDurationStrategy.class);
    @XStreamOmitField
    private ApplicationContext context;
    private final Class<? extends IAITakeLoanStrategy> strategyClass;

    ETakeLoanStrategyType(Class<? extends IAITakeLoanStrategy> strategyClass) {
        this.strategyClass = strategyClass;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public IAITakeLoanStrategy getStrategy() {
        return context.getBean(strategyClass);
    }
}
