package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

import java.util.Optional;

/**
 * Strategy for hiring a captain which always hires the captain if possible.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class HireCaptainAlwaysStrategy extends BaseHireCaptainStrategy {
    @Override
    public boolean shouldHire(IAIPlayer player, IShip vessel, ICity city) {
        if (vessel.getCaptian().isPresent()) {
            return false;
        }
        Optional<ICaptain> optCaptain = captainsState.getCaptain(city);
        return optCaptain.isPresent();
    }

}
