package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;

import java.util.Optional;

/**
 * Trade step to decide weather to hire or fire a trade manager.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class HireDismissTradeManagerStrategy extends BaseHireDismissTradeManagerStrategy {

    @Override
    public boolean hireOrFireTradeManager(ICity city, IAIPlayer player) {
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent()) {
            ITradingOffice office = optOffice.get();
            if (office.getSteward().isPresent()) {
                return false; // never dismiss
            } else {
                return player.getHometown().equals(city) ||
                        player.getPlayerContext().getHints(city).stream()
                                .filter(hint -> hint instanceof CentralStorageStrategyHint).findFirst().isPresent() ||
                        !player.findBuildings(city, IWorkShop.class).isEmpty();
            }
        }
        return false;
    }

}
