package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Optional;

/**
 * Base class providing common functionality.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 17, 2017
 */
public abstract class BaseBuyTradeStep implements ITradeStep {
    @Autowired
    @XStreamOmitField
    private TradeService tradeService;

    @Setter
    @Getter(AccessLevel.PROTECTED)
    private ICity city;
    @Setter
    @Getter
    private IWare ware;
    @Setter
    @Getter
    private INavigableVessel vessel;
    @Setter
    @Getter(AccessLevel.PROTECTED)
    private int maxBuyPrice;

    /**
     * Try transferring the required amount from storage if there is a store manager and the transfer is allowed. The
     * rest is then bought from the city.
     * @param player for which the transfer happens
     * @param maxAmount maximum amount of wares that should be loaded onto the vessel.
     */
    protected void transferFromOfficeOrBuyFromCity(IPlayer player, int maxAmount) {
        Optional<ITradingOffice> optOffice = player.findTradingOffice(city);
        if (optOffice.isPresent() && optOffice.get().getSteward().isPresent()) {
            ITradingOffice office = optOffice.get();
            if (office.getOfficeTrading().isMovableToShip(ware)) {
                int loaded = tradeService.transferFromStorageToVessel(office, vessel, player, ware, maxAmount);
                maxAmount -= loaded;
            }
        }
        if (maxAmount > 0) {
            tradeService.buyFromCityToShip(vessel, player, city, ware, maxAmount, Optional.of(maxBuyPrice), vessel.getCaptian());
        }
    }
}
