package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.AccessLevel;
import lombok.Setter;

/**
 * Implements the trade step to by the some goods up to a maximum buy price.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class BuyTradeStep extends BaseBuyTradeStep {

    @Setter(AccessLevel.PROTECTED)
    private boolean executeNext = true;


    @Override
    public boolean execute() {
        IPlayer player = (IPlayer) getVessel().getOwner();
        int maxAmount = getVessel().getCapacity();
        if (!getWare().isBarrelSizedWare()) {
            maxAmount /= 10;
        }
        transferFromOfficeOrBuyFromCity(player, maxAmount);
        return executeNext;

    }

    @Override
    public String toString() {
        return "BuyTradeStep{Buy "
        + getWare() + " for "
        + getVessel().getName() + " in "
        + getCity().getName() + " for a max price of"
        + getMaxBuyPrice() + "}";
    }
}
