package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Setter;

import java.util.Optional;

/**
 * Trade step for checking and hiring a captain.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class CheckHireCaptainTradeStep implements ITradeStep {
    @Setter
    private ICity city;
    @Setter
    private IAIPlayer player;
    @Setter
    private INavigableVessel vessel;
    @Override
    public boolean execute() {
        IAICaptainHireStrategy strategy = player.getCaptainHireStrategyType().getStrategy();
        IShip ship = null;
        if (vessel instanceof IShipGroup) {
            return true;
        }
        if (vessel instanceof IShip){
            ship = (IShip) vessel;
        }
        if (vessel instanceof IConvoy) {
            ship = ((IConvoy) vessel).getOrlegShip();
        }
        if (strategy.shouldHire(player, ship, city)) {
             Optional<ICaptain> captain = strategy.getCaptain(city);
             if (captain.isPresent()) {
                 strategy.hire(player, ship, captain.get(), city);
             }
        }
        return true;
    }
}
