package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Setter;

import java.util.Optional;

/**
 * Trade step to decide if a player should join the guild.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 16, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class GuildJoinTradeStep implements ITradeStep {
    @Setter
    private ICity city;
    @Setter
    private IAIPlayer player;
    @Setter
    private INavigableVessel vessel;

    @Override
    public boolean execute() {
        IAIGuildJoinStrategy strategy = player.getGuildJoinStrategyType().getStrategy();
        if (strategy.shouldJoin(player, city, Optional.ofNullable(vessel))) {
            strategy.join(player, city);
        }
        return true;
    }
}
