package ch.sahits.game.openpatrician.engine.player.tradesteps;

import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.List;

/**
 * Trade step to pay back a loan.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 24, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class PayBackLoanTradeStep implements ITradeStep {
    @Setter
    private ICity city;
    @Setter
    private IAIPlayer player;
    @Value("${loan.payback.limit}")
    private int cashLimit = 10000;
    @Autowired
    @XStreamOmitField
    private LoanerService loanerService;

    @Override
    public boolean execute() {
        ICompany company = player.getCompany();
        if (company.getCash() > cashLimit) {
            ILoaner loaner = loanerService.findLoaner(city);
            List<IDebt> debts = loanerService.findDebts(loaner, player);
            for (IDebt debt : debts) {
               // payback
                int debtTotal = loanerService.calculatePaybacksum(debt);
                debt.getCreditor().receiveSum(debtTotal);
                company.updateCashDirectly(-debtTotal);
                loaner.getDebts().remove(debt);
                if (company.getCash() < cashLimit) {
                    break;
                }
            }
        }
        return true;
    }
}
