/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event;

import ch.sahits.game.openpatrician.model.DisplayStateMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Optional;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class EventService {
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public Optional<ISpouseData> calculateSpouseDeath(IPlayer player, ICity city) {
        Optional<ISpouseData> killedSpouse = Optional.empty();
        if (player.getHometown().equals(city) && player.getSpouseData().isPresent() && this.rnd.nextInt(5) == 0) {
            killedSpouse = Optional.of((ISpouseData)player.getSpouseData().get());
            player.spouseDies();
        }
        return killedSpouse;
    }

    public void postToHumanPlayer(IDialogState state, IPlayer player, String messageKey, Object ... messageParams) {
        if (player instanceof IHumanPlayer) {
            DisplayStateMessage message = new DisplayStateMessage(messageKey, state, messageParams);
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)message));
        }
    }
}

