/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.event.task;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.event.data.RefitFinishedEvent;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class AIRefitTask
extends TimedTask {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(AIRefitTask.class);
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @XStreamOmitField
    private ShipWeaponsLocationFactory shipWeaponLocationFactory;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;
    private final IShip ship;
    private final EShipUpgrade level;
    private final IShipyard shipyard;

    public AIRefitTask(LocalDateTime executionTime, IShip ship, EShipUpgrade upgrade, IShipyard shipyard) {
        this.setExecutionTime(executionTime);
        LOGGER.debug("Add AIRefitTask for {} to be done at {}", (Object)ship.getName(), (Object)executionTime);
        this.ship = ship;
        this.level = upgrade;
        this.shipyard = shipyard;
    }

    public void run() {
        EShipUpgrade currentLevel = this.ship.getShipUpgradeLevel();
        while (currentLevel != this.level) {
            this.ship.upgrade();
            List oldWeaponSlots = this.ship.getWeaponSlots();
            List newWeaponSlots = this.shipWeaponLocationFactory.getShipWeaponsLocation(this.ship.getShipType(), this.level);
            this.ship.setWeaponSlots(newWeaponSlots);
            for (IWeaponSlot slot : oldWeaponSlots) {
                if (!slot.getWeapon().isPresent()) continue;
                EWeapon weapon = (EWeapon)slot.getWeapon().get();
                if (slot instanceof SecondaryLargeWeaponSlot) {
                    if (this.shipService.isLargeWeapon(weapon)) continue;
                    this.shipService.placeWeapon(weapon, this.ship);
                    continue;
                }
                this.shipService.placeWeapon(weapon, this.ship);
            }
            currentLevel = this.ship.getShipUpgradeLevel();
        }
        this.ship.setAvailable(true);
        this.shipyard.removeCompletedUpgrade(this.ship);
        LOGGER.debug("Refited ship {}", (Object)this.ship.getName());
        this.clientServerEventBus.post((Object)new RefitFinishedEvent(this.ship));
    }
}

