/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.player.BuyWeapons;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategy;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.PrimaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.weapon.ArmoryRegistry;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.utilities.javafx.bindings.ConstantIntegerBinding;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseBuyWeaponStrategy
implements IAIBuyWeaponStrategy {
    @Autowired
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private ArmoryRegistry registry;
    @Autowired
    @XStreamOmitField
    private ComputablePriceV2 computablePrice;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;

    protected int getNumberOfWeaponSlots(IShip ship) {
        return ship.getWeaponSlots().size();
    }

    protected int getNumberOfEmptyWeaponSlots(IShip ship) {
        return (int)ship.getWeaponSlots().stream().filter(slot -> !slot.getWeapon().isPresent()).count();
    }

    protected int getNumberOfEmptyLargeWeaponSlots(IShip ship) {
        List weaponSlots = ship.getWeaponSlots();
        int countFreeLarge = 0;
        for (int i = 0; i < weaponSlots.size(); ++i) {
            IWeaponSlot next;
            IWeaponSlot slot = (IWeaponSlot)weaponSlots.get(i);
            if (slot.getWeapon().isPresent() || !(slot instanceof PrimaryLargeWeaponSlot) || (next = (IWeaponSlot)weaponSlots.get(i + 1)).getWeapon().isPresent() || !(next instanceof SecondaryLargeWeaponSlot)) continue;
            ++countFreeLarge;
        }
        return countFreeLarge;
    }

    protected int getWeaponAmount(IArmory armory, EWeapon weapon) {
        switch (weapon) {
            case HAND_WEAPON: {
                return armory.cutlassAmountProperty().get();
            }
            case BALLISTA_BIG: {
                return armory.ballistaBigAmountProperty().get();
            }
            case BALLISTA_SMALL: {
                return armory.ballistaSmallAmountProperty().get();
            }
            case TREBUCHET_BIG: {
                return armory.trebuchetBigAmountProperty().get();
            }
            case TREBUCHET_SMALL: {
                return armory.trebuchetSmallAmountProperty().get();
            }
            case BOMBARD: {
                return armory.bombardAmountProperty().get();
            }
            case CANNON: {
                return armory.canonAmountProperty().get();
            }
        }
        throw new IllegalArgumentException("Unhandled weapon type: " + weapon);
    }

    protected EWeapon buyLargeWeapon(IArmory armory, int capacity) {
        ArrayList<EWeapon> weapons = new ArrayList<EWeapon>();
        if (this.getWeaponAmount(armory, EWeapon.BALLISTA_BIG) > 0 && (double)capacity > EWeapon.BALLISTA_BIG.getSize()) {
            weapons.add(EWeapon.BALLISTA_BIG);
        }
        if (this.getWeaponAmount(armory, EWeapon.TREBUCHET_BIG) > 0 && (double)capacity > EWeapon.TREBUCHET_BIG.getSize()) {
            weapons.add(EWeapon.TREBUCHET_BIG);
        }
        if (this.getWeaponAmount(armory, EWeapon.BOMBARD) > 0 && (double)capacity > EWeapon.BOMBARD.getSize()) {
            weapons.add(EWeapon.BOMBARD);
        }
        if (weapons.isEmpty()) {
            return null;
        }
        EWeapon chosenWeapon = (EWeapon)weapons.get(this.rnd.nextInt(weapons.size()));
        switch (chosenWeapon) {
            case TREBUCHET_BIG: {
                armory.updateTrebuchetBigAmount(-1);
                break;
            }
            case BALLISTA_BIG: {
                armory.updateBallistaBigAmount(-1);
                break;
            }
            case BOMBARD: {
                armory.updateBombardAmount(-1);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot buy big weapon of type " + chosenWeapon);
            }
        }
        return chosenWeapon;
    }

    protected EWeapon buySmallWeapon(IArmory armory, int capacity) {
        ArrayList<EWeapon> weapons = new ArrayList<EWeapon>();
        if (this.getWeaponAmount(armory, EWeapon.BALLISTA_SMALL) > 0 && (double)capacity > EWeapon.BALLISTA_SMALL.getSize()) {
            weapons.add(EWeapon.BALLISTA_SMALL);
        }
        if (this.getWeaponAmount(armory, EWeapon.TREBUCHET_SMALL) > 0 && (double)capacity > EWeapon.TREBUCHET_SMALL.getSize()) {
            weapons.add(EWeapon.TREBUCHET_SMALL);
        }
        if (this.getWeaponAmount(armory, EWeapon.CANNON) > 0 && (double)capacity > EWeapon.CANNON.getSize()) {
            weapons.add(EWeapon.CANNON);
        }
        if (weapons.isEmpty()) {
            return null;
        }
        EWeapon chosenWeapon = (EWeapon)weapons.get(this.rnd.nextInt(weapons.size()));
        switch (chosenWeapon) {
            case TREBUCHET_SMALL: {
                armory.updateTrebuchetSmallAmount(-1);
                break;
            }
            case BALLISTA_SMALL: {
                armory.updateBallistaSmallAmount(-1);
                break;
            }
            case CANNON: {
                armory.updateCanonAmount(-1);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot buy small weapon of type " + chosenWeapon);
            }
        }
        return chosenWeapon;
    }

    public void buyWeapons(BuyWeapons target, IShip ship, IAIPlayer player, ICity city) {
        EWeapon boughtWeapon;
        EWeapon boughtWeapon2;
        IArmory armory = this.registry.getArmory(city);
        int availableHandWeapons = this.getWeaponAmount(armory, EWeapon.HAND_WEAPON);
        int buyHandWeapons = Math.min(availableHandWeapons, target.getHandWeapons());
        armory.updateCutlassAmount(-buyHandWeapons);
        int price = this.computablePrice.buyPrice((ITradable)EWeapon.HAND_WEAPON, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableHandWeapons), (IntegerBinding)new ConstantIntegerBinding(buyHandWeapons));
        int costs = price * buyHandWeapons;
        for (int i = 0; i < buyHandWeapons; ++i) {
            this.shipService.placeWeapon(EWeapon.HAND_WEAPON, ship);
        }
        for (int boughtLargeWeapons = 0; boughtLargeWeapons < target.getLargeWeapons() && this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship) < target.getTotalStrength() && (boughtWeapon2 = this.buyLargeWeapon(armory, ship.getCapacity())) != null; ++boughtLargeWeapons) {
            SimpleIntegerProperty available = new SimpleIntegerProperty(this.getWeaponAmount(armory, boughtWeapon2));
            price = this.computablePrice.buyPrice((ITradable)boughtWeapon2, (ReadOnlyIntegerProperty)available, (IntegerBinding)new ConstantIntegerBinding(1));
            costs += price;
            this.shipService.placeWeapon(boughtWeapon2, ship);
        }
        for (int boughtSmallWeapons = 0; boughtSmallWeapons < target.getSmallWeapons() && this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship) < target.getTotalStrength() && (boughtWeapon = this.buySmallWeapon(armory, ship.getCapacity())) != null; ++boughtSmallWeapons) {
            SimpleIntegerProperty available = new SimpleIntegerProperty(this.getWeaponAmount(armory, boughtWeapon));
            price = this.computablePrice.buyPrice((ITradable)boughtWeapon, (ReadOnlyIntegerProperty)available, (IntegerBinding)new ConstantIntegerBinding(1));
            costs += price;
            this.shipService.placeWeapon(boughtWeapon, ship);
        }
        if (player instanceof IHumanPlayer) {
            player.getCompany().updateCash((long)(-costs));
        } else {
            player.getCompany().updateCashDirectly((long)(-costs));
        }
    }
}

