/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.engine.player.strategy;

import ch.sahits.game.openpatrician.engine.player.strategy.BaseShipConstructionSelectionStrategy;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BiggestShipConstructionSelectionStrategy
extends BaseShipConstructionSelectionStrategy {
    public BiggestShipConstructionSelectionStrategy(int minCash, int maxFeetSize, int maxTotalCargoCapacity) {
        super(minCash, maxFeetSize, maxTotalCargoCapacity);
    }

    public EShipType shouldBuildShipType(IAIPlayer player) {
        int maxTotalCargoCapacity;
        ICity where = this.getBuildLocation(player);
        ArrayList<EShipType> shipTypes = new ArrayList<EShipType>(Arrays.asList(where.getCityState().getShipyardState().getBuildableShipTypes()));
        int fleetCapacity = this.getFleetCapacity(player.getFleet());
        double capacityOfMaxPercent = (double)fleetCapacity * 1.0 / (double)(maxTotalCargoCapacity = this.getMaxTotalCargoCapacity());
        if (capacityOfMaxPercent >= 0.7) {
            return this.biggestShipType(shipTypes);
        }
        if (capacityOfMaxPercent <= 0.3) {
            shipTypes.remove(EShipType.HOLK);
        }
        if (capacityOfMaxPercent <= 0.1) {
            shipTypes.remove(EShipType.COG);
        }
        if (capacityOfMaxPercent <= 0.05) {
            shipTypes.remove(EShipType.CRAYER);
        }
        return this.biggestShipType(shipTypes);
    }

    private EShipType biggestShipType(List<EShipType> shipTypes) {
        EShipType[] sizedTypes;
        for (EShipType type : sizedTypes = new EShipType[]{EShipType.HOLK, EShipType.COG, EShipType.CRAYER, EShipType.SNAIKKA}) {
            if (!shipTypes.contains(type)) continue;
            return type;
        }
        return null;
    }
}

